/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.executor.sql.execute;

import io.shardingsphere.core.event.ShardingEventBusInstance;
import io.shardingsphere.core.event.executor.overall.OverallExecutionEvent;
import io.shardingsphere.core.executor.ShardingExecuteEngine;
import io.shardingsphere.core.executor.ShardingExecuteGroup;
import io.shardingsphere.core.executor.sql.SQLExecuteUnit;
import io.shardingsphere.core.executor.sql.execute.SQLExecuteCallback;
import io.shardingsphere.core.executor.sql.execute.threadlocal.ExecutorExceptionHandler;
import java.beans.ConstructorProperties;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class SQLExecuteTemplate {
    private final ShardingExecuteEngine executeEngine;

    public <T> List<T> execute(Collection<? extends SQLExecuteUnit> sqlExecuteUnits, SQLExecuteCallback<T> callback) throws SQLException {
        return this.execute(sqlExecuteUnits, null, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> execute(Collection<? extends SQLExecuteUnit> sqlExecuteUnits, SQLExecuteCallback<T> firstExecuteCallback, SQLExecuteCallback<T> callback) throws SQLException {
        OverallExecutionEvent event = new OverallExecutionEvent(sqlExecuteUnits.size() > 1);
        ShardingEventBusInstance.getInstance().post((Object)event);
        try {
            List result = this.executeEngine.execute(sqlExecuteUnits, firstExecuteCallback, callback);
            event.setExecuteSuccess();
            List list = result;
            return list;
        }
        catch (Exception ex) {
            event.setExecuteFailure(ex);
            ExecutorExceptionHandler.handleException(ex);
            List list = Collections.emptyList();
            return list;
        }
        finally {
            ShardingEventBusInstance.getInstance().post((Object)event);
        }
    }

    public <T> List<T> executeGroup(Collection<ShardingExecuteGroup<? extends SQLExecuteUnit>> sqlExecuteGroups, SQLExecuteCallback<T> callback) throws SQLException {
        return this.executeGroup(sqlExecuteGroups, null, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> executeGroup(Collection<ShardingExecuteGroup<? extends SQLExecuteUnit>> sqlExecuteGroups, SQLExecuteCallback<T> firstCallback, SQLExecuteCallback<T> callback) throws SQLException {
        OverallExecutionEvent event = new OverallExecutionEvent(sqlExecuteGroups.size() > 1);
        ShardingEventBusInstance.getInstance().post((Object)event);
        try {
            List result = this.executeEngine.groupExecute(sqlExecuteGroups, firstCallback, callback);
            event.setExecuteSuccess();
            List list = result;
            return list;
        }
        catch (Exception ex) {
            event.setExecuteFailure(ex);
            ExecutorExceptionHandler.handleException(ex);
            List list = Collections.emptyList();
            return list;
        }
        finally {
            ShardingEventBusInstance.getInstance().post((Object)event);
        }
    }

    @ConstructorProperties(value={"executeEngine"})
    public SQLExecuteTemplate(ShardingExecuteEngine executeEngine) {
        this.executeEngine = executeEngine;
    }
}

