/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.executor.sql.execute;

import com.google.common.eventbus.EventBus;
import io.shardingsphere.core.constant.SQLType;
import io.shardingsphere.core.event.ShardingEventBusInstance;
import io.shardingsphere.core.event.executor.sql.SQLExecutionEvent;
import io.shardingsphere.core.event.executor.sql.SQLExecutionEventFactory;
import io.shardingsphere.core.executor.ShardingExecuteCallback;
import io.shardingsphere.core.executor.ShardingGroupExecuteCallback;
import io.shardingsphere.core.executor.sql.SQLExecuteUnit;
import io.shardingsphere.core.executor.sql.execute.threadlocal.ExecutorDataMap;
import io.shardingsphere.core.executor.sql.execute.threadlocal.ExecutorExceptionHandler;
import java.beans.ConstructorProperties;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class SQLExecuteCallback<T>
implements ShardingExecuteCallback<SQLExecuteUnit, T>,
ShardingGroupExecuteCallback<SQLExecuteUnit, T> {
    private final SQLType sqlType;
    private final boolean isExceptionThrown;
    private final Map<String, Object> dataMap;
    private final EventBus shardingEventBus = ShardingEventBusInstance.getInstance();

    @Override
    public final T execute(SQLExecuteUnit sqlExecuteUnit) throws SQLException {
        return this.execute0(sqlExecuteUnit);
    }

    @Override
    public final Collection<T> execute(Collection<SQLExecuteUnit> sqlExecuteUnits) throws SQLException {
        LinkedList<T> result = new LinkedList<T>();
        for (SQLExecuteUnit each : sqlExecuteUnits) {
            result.add(this.execute0(each));
        }
        return result;
    }

    private T execute0(SQLExecuteUnit sqlExecuteUnit) throws SQLException {
        ExecutorExceptionHandler.setExceptionThrown(this.isExceptionThrown);
        ExecutorDataMap.setDataMap(this.dataMap);
        LinkedList<SQLExecutionEvent> events = new LinkedList<SQLExecutionEvent>();
        for (List<Object> each : sqlExecuteUnit.getRouteUnit().getSqlUnit().getParameterSets()) {
            SQLExecutionEvent event = SQLExecutionEventFactory.createEvent(this.sqlType, sqlExecuteUnit, each);
            events.add(event);
            this.shardingEventBus.post((Object)event);
        }
        try {
            T result = this.executeSQL(sqlExecuteUnit);
            for (SQLExecutionEvent each : events) {
                each.setExecuteSuccess();
                this.shardingEventBus.post((Object)each);
            }
            return result;
        }
        catch (SQLException ex) {
            for (SQLExecutionEvent each : events) {
                each.setExecuteFailure(ex);
                this.shardingEventBus.post((Object)each);
                ExecutorExceptionHandler.handleException(ex);
            }
            return null;
        }
    }

    protected abstract T executeSQL(SQLExecuteUnit var1) throws SQLException;

    @ConstructorProperties(value={"sqlType", "isExceptionThrown", "dataMap"})
    public SQLExecuteCallback(SQLType sqlType, boolean isExceptionThrown, Map<String, Object> dataMap) {
        this.sqlType = sqlType;
        this.isExceptionThrown = isExceptionThrown;
        this.dataMap = dataMap;
    }
}

