/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.swagger.invocation.response.producer;

import io.servicecomb.swagger.invocation.response.producer.ProducerResponseMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class ProducerResponseMapperFactory {
    private ProducerResponseMapper defaultMapper;
    private Map<Class<?>, ProducerResponseMapper> mappers = new HashMap();

    @Inject
    public void setMapperList(List<ProducerResponseMapper> mapperList) {
        for (ProducerResponseMapper mapper : mapperList) {
            if (mapper.getResponseClass() == null) {
                this.defaultMapper = mapper;
                continue;
            }
            this.mappers.put(mapper.getResponseClass(), mapper);
        }
    }

    public ProducerResponseMapper createResponseMapper(Class<?> cls) {
        ProducerResponseMapper mapper = this.mappers.get(cls);
        if (mapper == null) {
            return this.defaultMapper;
        }
        return mapper;
    }
}

