/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.swagger.invocation.response.consumer;

import io.servicecomb.swagger.invocation.response.consumer.ConsumerResponseMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class ConsumerResponseMapperFactory {
    private ConsumerResponseMapper defaultMapper;
    private Map<Class<?>, ConsumerResponseMapper> mappers = new HashMap();

    @Inject
    public void setMapperList(List<ConsumerResponseMapper> mapperList) {
        for (ConsumerResponseMapper mapper : mapperList) {
            if (mapper.getResponseClass() == null) {
                this.defaultMapper = mapper;
                continue;
            }
            this.mappers.put(mapper.getResponseClass(), mapper);
        }
    }

    public ConsumerResponseMapper createResponseMapper(Class<?> cls) {
        ConsumerResponseMapper mapper = this.mappers.get(cls);
        if (mapper == null) {
            return this.defaultMapper;
        }
        return mapper;
    }
}

