/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.swagger.invocation.arguments.consumer;

import io.servicecomb.swagger.invocation.arguments.ArgumentMapper;
import io.servicecomb.swagger.invocation.arguments.ArgumentsMapperConfig;
import io.servicecomb.swagger.invocation.arguments.ArgumentsMapperFactory;
import io.servicecomb.swagger.invocation.arguments.ContextArgumentMapperFactory;
import io.servicecomb.swagger.invocation.arguments.consumer.ConsumerArgumentSame;
import io.servicecomb.swagger.invocation.arguments.consumer.ConsumerArgumentToBodyField;
import io.servicecomb.swagger.invocation.arguments.consumer.ConsumerArgumentsMapper;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ConsumerArgumentsMapperFactory
extends ArgumentsMapperFactory {
    @Inject
    @Qualifier(value="consumer")
    public void setFactoryList(List<ContextArgumentMapperFactory> factoryList) {
        this.createFactoryMap(factoryList);
    }

    @Override
    protected <T> T createArgumentsMapper(ArgumentsMapperConfig config) {
        return (T)new ConsumerArgumentsMapper(config.getArgumentMapperList(), config.getSwaggerParameters().size());
    }

    @Override
    protected ArgumentMapper createArgumentSame(int swaggerIdx, int consumerIdx) {
        return new ConsumerArgumentSame(consumerIdx, swaggerIdx);
    }

    @Override
    protected ArgumentMapper createBodyFieldArgMapper(ArgumentsMapperConfig config, int swaggerArgIdx, Map<Integer, Field> fieldMap) {
        Class<?> swaggerParamType = config.getSwaggerMethod().getParameterTypes()[swaggerArgIdx];
        return new ConsumerArgumentToBodyField(swaggerParamType, swaggerArgIdx, fieldMap);
    }
}

