/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.swagger.invocation.arguments;

import io.servicecomb.swagger.extend.parameter.ContextParameter;
import io.servicecomb.swagger.invocation.arguments.ArgumentMapper;
import io.servicecomb.swagger.invocation.arguments.ArgumentsMapperConfig;
import io.servicecomb.swagger.invocation.arguments.ContextArgumentMapperFactory;
import io.swagger.models.Model;
import io.swagger.models.RefModel;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public abstract class ArgumentsMapperFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArgumentsMapperFactory.class);
    private Map<Class<?>, ContextArgumentMapperFactory> factoryMap = new HashMap();

    protected int findInParameters(String parameterName, List<Parameter> parameters) {
        for (int idx = 0; idx < parameters.size(); ++idx) {
            Parameter parameter = parameters.get(idx);
            if (!parameterName.equals(parameter.getName())) continue;
            return idx;
        }
        return -1;
    }

    protected void createFactoryMap(List<ContextArgumentMapperFactory> factoryList) {
        factoryList.forEach(factory -> this.factoryMap.put(factory.getContextClass(), (ContextArgumentMapperFactory)factory));
    }

    protected ContextArgumentMapperFactory findFactory(Class<?> cls) {
        return this.factoryMap.get(cls);
    }

    public <T> T createArgumentsMapper(Swagger swagger, Method swaggerMethod, List<Parameter> swaggerParameters, Method providerMethod, List<Parameter> providerParameters) {
        ArgumentsMapperConfig config = new ArgumentsMapperConfig();
        config.setSwagger(swagger);
        config.setSwaggerMethod(swaggerMethod);
        config.setSwaggerParameters(swaggerParameters);
        config.setProviderMethod(providerMethod);
        config.setProviderParameters(providerParameters);
        this.collectContextArgumentsMapper(config);
        this.collectSwaggerArgumentsMapper(config);
        return this.createArgumentsMapper(config);
    }

    protected abstract <T> T createArgumentsMapper(ArgumentsMapperConfig var1);

    protected abstract ArgumentMapper createArgumentSame(int var1, int var2);

    protected abstract ArgumentMapper createBodyFieldArgMapper(ArgumentsMapperConfig var1, int var2, Map<Integer, Field> var3);

    protected void collectSwaggerArgumentsMapper(ArgumentsMapperConfig config) {
        for (int swaggerIdx = 0; swaggerIdx < config.getSwaggerParameters().size(); ++swaggerIdx) {
            Parameter swaggerParameter = config.getSwaggerParameters().get(swaggerIdx);
            int providerIdx = this.findInParameters(swaggerParameter.getName(), config.getProviderParameters());
            if (providerIdx >= 0) {
                if (BodyParameter.class.isInstance(swaggerParameter)) {
                    this.mapBodyArg(config, providerIdx, swaggerIdx);
                    continue;
                }
                config.addArgumentMapper(this.createArgumentSame(swaggerIdx, providerIdx));
                continue;
            }
            if (BodyParameter.class.isInstance(swaggerParameter)) {
                this.processBodyArgMapper(config, swaggerIdx);
                continue;
            }
            LOGGER.warn(this.generateSkipParamInfo("parameter", config, swaggerParameter.getName()));
        }
    }

    protected void processBodyArgMapper(ArgumentsMapperConfig config, int swaggerIdx) {
        Parameter swaggerParameter = config.getSwaggerParameters().get(swaggerIdx);
        List<Integer> providerBodyIndexList = this.getBodyIndexList(config.getProviderParameters());
        if (providerBodyIndexList.isEmpty()) {
            LOGGER.warn(this.generateSkipParamInfo("parameter", config, swaggerParameter.getName()));
            return;
        }
        if (providerBodyIndexList.size() == 1) {
            int providerBodyArgIdx = providerBodyIndexList.get(0);
            this.mapBodyArg(config, providerBodyArgIdx, swaggerIdx);
            return;
        }
        this.processBodyFieldArgMapper(config, swaggerIdx);
    }

    protected void mapBodyArg(ArgumentsMapperConfig config, int providerBodyArgIdx, int swaggerBodyArgIdx) {
        Type swaggerParameterType;
        Type providerParameterType = config.getProviderMethod().getGenericParameterTypes()[providerBodyArgIdx];
        if (providerParameterType.equals(swaggerParameterType = config.getSwaggerMethod().getGenericParameterTypes()[swaggerBodyArgIdx])) {
            config.addArgumentMapper(this.createArgumentSame(swaggerBodyArgIdx, providerBodyArgIdx));
            return;
        }
        this.processBodyFieldArgMapper(config, swaggerBodyArgIdx);
    }

    protected void collectContextArgumentsMapper(ArgumentsMapperConfig config) {
        for (int providerIdx = 0; providerIdx < config.getProviderParameters().size(); ++providerIdx) {
            Parameter providerParameter = config.getProviderParameters().get(providerIdx);
            if (!ContextParameter.class.isInstance(providerParameter)) continue;
            ContextArgumentMapperFactory factory = this.findFactory(providerParameter.getClass());
            if (factory != null) {
                ArgumentMapper mapper = factory.create(providerIdx);
                config.addArgumentMapper(mapper);
                continue;
            }
            throw new Error("unknown context parameter " + providerParameter.getClass().getName());
        }
    }

    protected void processBodyFieldArgMapper(ArgumentsMapperConfig config, int swaggerIdx) {
        Class<?>[] swaggerParameterTypes = config.getSwaggerMethod().getParameterTypes();
        Class<?> swaggerParameterType = swaggerParameterTypes[swaggerIdx];
        BodyParameter bp = (BodyParameter)config.getSwaggerParameters().get(swaggerIdx);
        Model model = bp.getSchema();
        if (RefModel.class.isInstance(model)) {
            String refName = ((RefModel)model).getSimpleRef();
            model = (Model)config.getSwagger().getDefinitions().get(refName);
        }
        HashMap<Integer, Field> fieldMap = new HashMap<Integer, Field>();
        for (String propertyName : model.getProperties().keySet()) {
            int providerIdx = this.findInParameters(propertyName, config.getProviderParameters());
            if (providerIdx >= 0) {
                Field field = ReflectionUtils.findField(swaggerParameterType, (String)propertyName);
                field.setAccessible(true);
                fieldMap.put(providerIdx, field);
                continue;
            }
            String msg = this.generateSkipParamInfo("body parameter field", config, propertyName);
            LOGGER.warn(msg);
        }
        ArgumentMapper bodyFieldArg = this.createBodyFieldArgMapper(config, swaggerIdx, fieldMap);
        config.addArgumentMapper(bodyFieldArg);
    }

    protected List<Integer> getBodyIndexList(List<Parameter> providerParameters) {
        ArrayList<Integer> providerBodyIndexList = new ArrayList<Integer>();
        for (int idx = 0; idx < providerParameters.size(); ++idx) {
            Parameter parameter = providerParameters.get(idx);
            if (!BodyParameter.class.isInstance(parameter)) continue;
            providerBodyIndexList.add(idx);
        }
        return providerBodyIndexList;
    }

    protected String generateSkipParamInfo(String parameterDesc, ArgumentsMapperConfig config, String swaggerParameterName) {
        List names = config.getProviderParameters().stream().map(p -> p.getName()).collect(Collectors.toList());
        return String.format("skip %s %s of swagger %s:%s, not found in provider %s:%s(%s)", parameterDesc, swaggerParameterName, config.getSwaggerMethod().getDeclaringClass().getName(), config.getSwaggerMethod().getName(), config.getProviderMethod().getDeclaringClass().getName(), config.getProviderMethod().getName(), names);
    }
}

