/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.core.context;

import io.servicecomb.core.context.HttpStatus;
import io.servicecomb.foundation.common.utils.SPIServiceUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.Response;

public class HttpStatusManager {
    private Map<Integer, Response.StatusType> statusMap = new ConcurrentHashMap<Integer, Response.StatusType>();

    public HttpStatusManager() {
        for (Response.Status status2 : Response.Status.values()) {
            this.statusMap.put(status2.getStatusCode(), (Response.StatusType)status2);
        }
        SPIServiceUtils.getAllService(Response.StatusType.class).forEach(status -> this.addStatusType((Response.StatusType)status));
    }

    public void addStatusType(Response.StatusType status) {
        if (this.statusMap.containsKey(status.getStatusCode())) {
            throw new Error("repeated status code: " + status.getStatusCode());
        }
        this.statusMap.put(status.getStatusCode(), status);
    }

    public Response.StatusType getOrCreateByStatusCode(int code) {
        Response.StatusType statusType = this.statusMap.get(code);
        if (statusType != null) {
            return statusType;
        }
        statusType = new HttpStatus(code, "");
        this.addStatusType(statusType);
        return statusType;
    }
}

