/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.core;

import io.servicecomb.core.context.HttpStatus;
import io.servicecomb.core.exception.CommonExceptionData;
import io.servicecomb.core.exception.ExceptionFactory;
import io.servicecomb.core.exception.InvocationException;
import io.servicecomb.core.invocation.InvocationType;
import io.servicecomb.swagger.invocation.response.Headers;
import javax.ws.rs.core.Response;

public class Response {
    private Response.StatusType status;
    private Headers headers = new Headers();
    private Object result;

    public boolean isSuccessed() {
        return HttpStatus.isSuccess(this.status);
    }

    public boolean isFailed() {
        return !this.isSuccessed();
    }

    public int getStatusCode() {
        return this.status.getStatusCode();
    }

    public String getReasonPhrase() {
        return this.status.getReasonPhrase();
    }

    public Response.StatusType getStatus() {
        return this.status;
    }

    public void setStatus(Response.StatusType status) {
        this.status = status;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public void setHeaders(Headers headers) {
        this.headers = headers;
    }

    public <T> T getResult() {
        return (T)this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public static Response create(int statusCode, String reasonPhrase, Object result) {
        HttpStatus status = new HttpStatus(statusCode, reasonPhrase);
        return Response.create(status, result);
    }

    public static Response create(Response.StatusType status, Object result) {
        Response response = Response.status(status);
        if (response.isFailed()) {
            result = ExceptionFactory.create(status, result);
        }
        return response.entity(result);
    }

    public static Response createSuccess(Response.StatusType status, Object result) {
        return Response.status(status).entity(result);
    }

    public static Response createSuccess(Object result) {
        return Response.status((Response.StatusType)Response.Status.OK).entity(result);
    }

    public static Response createFail(InvocationException exception) {
        return Response.status(exception.getStatus()).entity(exception);
    }

    public static Response createFail(InvocationType invocationType, String errorMsg) {
        CommonExceptionData errorData = new CommonExceptionData(errorMsg);
        if (InvocationType.CONSUMER.equals((Object)invocationType)) {
            return Response.createFail(ExceptionFactory.createConsumerException(errorData));
        }
        return Response.createFail(ExceptionFactory.createProducerException(errorData));
    }

    public static Response createFail(InvocationType invocationType, Throwable throwable) {
        if (InvocationType.CONSUMER.equals((Object)invocationType)) {
            return Response.createConsumerFail(throwable);
        }
        return Response.createProducerFail(throwable);
    }

    public static Response createConsumerFail(Throwable throwable) {
        InvocationException exception = ExceptionFactory.convertConsumerException(throwable);
        return Response.createFail(exception);
    }

    public static Response createProducerFail(Throwable throwable) {
        InvocationException exception = ExceptionFactory.convertProducerException(throwable);
        return Response.createFail(exception);
    }

    public static Response consumerFailResp(Throwable e) {
        return Response.createConsumerFail(e);
    }

    public static Response producerFailResp(Throwable e) {
        return Response.createProducerFail(e);
    }

    public static Response providerFailResp(Throwable e) {
        return Response.createProducerFail(e);
    }

    public static Response success(Object result, Response.StatusType status) {
        return Response.createSuccess(status, result);
    }

    public static Response succResp(Object result) {
        return Response.createSuccess(result);
    }

    public static Response failResp(InvocationException e) {
        return Response.createFail(e);
    }

    public static Response failResp(InvocationType invocationType, Throwable e) {
        return Response.createFail(invocationType, e);
    }

    public Response entity(Object result) {
        this.setResult(result);
        return this;
    }

    public Response build() {
        return this;
    }

    public static Response status(Response.StatusType status) {
        Response response = new Response();
        response.setStatus(status);
        return response;
    }

    public static Response ok(Object result) {
        Response response = new Response();
        response.setStatus((Response.StatusType)Response.Status.OK);
        response.setResult(result);
        return response;
    }
}

