/*
 * Copyright 2017 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.servicecomb.swagger.invocation;

import io.servicecomb.core.invocation.InvocationType;

public class SwaggerInvocation extends SwaggerInvocationContext {
    // 本实例是在consumer端，还是在provider端
    protected InvocationType invocationType;

    protected Object[] swaggerArguments;

    public InvocationType getInvocationType() {
        return invocationType;
    }

    public Object[] getSwaggerArguments() {
        return swaggerArguments;
    }

    @SuppressWarnings("unchecked")
    public <T> T getSwaggerArgument(int idx) {
        return (T) swaggerArguments[idx];
    }

    public void setSwaggerArguments(Object[] swaggerArguments) {
        this.swaggerArguments = swaggerArguments;
    }

    public void setSwaggerArgument(int idx, Object swaggerArgument) {
        this.swaggerArguments[idx] = swaggerArgument;
    }
}
