/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.swagger.generator.jaxrs;

import io.servicecomb.swagger.generator.core.utils.ClassUtils;
import io.servicecomb.swagger.generator.jaxrs.processor.annotation.ConsumesAnnotationProcessor;
import io.servicecomb.swagger.generator.jaxrs.processor.annotation.CookieParamAnnotationProcessor;
import io.servicecomb.swagger.generator.jaxrs.processor.annotation.FormParamAnnotationProcessor;
import io.servicecomb.swagger.generator.jaxrs.processor.annotation.HeaderParamAnnotationProcessor;
import io.servicecomb.swagger.generator.jaxrs.processor.annotation.HttpMethodAnnotationProcessor;
import io.servicecomb.swagger.generator.jaxrs.processor.annotation.PathClassAnnotationProcessor;
import io.servicecomb.swagger.generator.jaxrs.processor.annotation.PathMethodAnnotationProcessor;
import io.servicecomb.swagger.generator.jaxrs.processor.annotation.PathParamAnnotationProcessor;
import io.servicecomb.swagger.generator.jaxrs.processor.annotation.ProducesAnnotationProcessor;
import io.servicecomb.swagger.generator.jaxrs.processor.annotation.QueryParamAnnotationProcessor;
import io.servicecomb.swagger.generator.jaxrs.processor.parameter.JaxrsDefaultParameterProcessor;
import io.servicecomb.swagger.generator.jaxrs.processor.response.ResponseProcessor;
import io.servicecomb.swagger.generator.rest.RestSwaggerGeneratorContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

public class JaxrsSwaggerGeneratorContext
extends RestSwaggerGeneratorContext {
    private static final int ORDER = 2000;

    public int getOrder() {
        return 2000;
    }

    public boolean canProcess(Class<?> cls) {
        return ClassUtils.hasAnnotation(cls, Path.class);
    }

    public boolean canProcess(Method method) {
        for (Annotation annotation : method.getAnnotations()) {
            HttpMethod httpMethod = annotation.annotationType().getAnnotation(HttpMethod.class);
            if (httpMethod == null) continue;
            return true;
        }
        return false;
    }

    protected void initDefaultParameterProcessor() {
        this.defaultParameterProcessor = new JaxrsDefaultParameterProcessor();
    }

    protected void initClassAnnotationMgr() {
        super.initClassAnnotationMgr();
        this.classAnnotationMgr.register(Path.class, (Object)new PathClassAnnotationProcessor());
    }

    protected void initMethodAnnotationMgr() {
        super.initMethodAnnotationMgr();
        this.methodAnnotationMgr.register(Path.class, (Object)new PathMethodAnnotationProcessor());
        this.methodAnnotationMgr.register(Produces.class, (Object)new ProducesAnnotationProcessor());
        this.methodAnnotationMgr.register(Consumes.class, (Object)new ConsumesAnnotationProcessor());
        HttpMethodAnnotationProcessor httpMethodProcessor = new HttpMethodAnnotationProcessor();
        this.methodAnnotationMgr.register(GET.class, (Object)httpMethodProcessor);
        this.methodAnnotationMgr.register(POST.class, (Object)httpMethodProcessor);
        this.methodAnnotationMgr.register(PUT.class, (Object)httpMethodProcessor);
        this.methodAnnotationMgr.register(DELETE.class, (Object)httpMethodProcessor);
    }

    protected void initParameterAnnotationMgr() {
        super.initParameterAnnotationMgr();
        this.parameterAnnotationMgr.register(PathParam.class, (Object)new PathParamAnnotationProcessor());
        this.parameterAnnotationMgr.register(FormParam.class, (Object)new FormParamAnnotationProcessor());
        this.parameterAnnotationMgr.register(CookieParam.class, (Object)new CookieParamAnnotationProcessor());
        this.parameterAnnotationMgr.register(HeaderParam.class, (Object)new HeaderParamAnnotationProcessor());
        this.parameterAnnotationMgr.register(QueryParam.class, (Object)new QueryParamAnnotationProcessor());
    }

    protected void initResponseTypeProcessorMgr() {
        super.initResponseTypeProcessorMgr();
        this.responseTypeProcessorMgr.register(Response.class, (Object)new ResponseProcessor());
    }
}

