/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.springboot.starter.transport;

import io.servicecomb.transport.rest.servlet.RestServlet;
import javax.servlet.Servlet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;

@Configuration
public class CseEmbeddedServlet {
    @Autowired
    private ConfigurableEnvironment env;
    private static final String DEFAULT_SERVLET_NAME = "RestServlet";
    private static final String DEFAULT_URL = "/pojo/rest/*";

    @Bean
    public ServletRegistrationBean restServletRegistration() {
        String name = this.env.getProperty("cse.servlet.name");
        name = name == null ? DEFAULT_SERVLET_NAME : name;
        String url = this.env.getProperty("cse.servlet.url");
        url = url == null ? DEFAULT_URL : url;
        ServletRegistrationBean registrationBean = new ServletRegistrationBean((Servlet)new RestServlet(), new String[]{url});
        registrationBean.setName(name);
        return registrationBean;
    }
}

