/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.springboot.starter.discovery;

import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractServerList;
import com.netflix.loadbalancer.Server;
import io.servicecomb.loadbalance.ServerListCache;
import io.servicecomb.springboot.starter.discovery.CseRoutesProperties;
import io.servicecomb.springboot.starter.discovery.CseServerListCacheWrapper;
import io.servicecomb.springboot.starter.discovery.ServiceCombDiscoveryException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCombServerList
extends AbstractServerList<Server> {
    private static final Logger logger = LoggerFactory.getLogger(ServiceCombServerList.class);
    private final CseRoutesProperties config;
    private ServerListCache serverListCache;
    private String serviceId;

    public ServiceCombServerList(CseRoutesProperties config) {
        this.config = config;
    }

    public List<Server> getInitialListOfServers() {
        return this.servers();
    }

    public List<Server> getUpdatedListOfServers() {
        return this.servers();
    }

    private List<Server> servers() {
        if (this.serverListCache == null) {
            throw new ServiceCombDiscoveryException("Service list is not initialized");
        }
        logger.info("Looking for service with app id: {}, service id: {}, version rule: {}", new Object[]{this.config.getAppID(), this.serviceId, this.config.getVersionRule(this.serviceId)});
        List endpoints = this.serverListCache.getLatestEndpoints();
        logger.info("Found service endpoints {}", (Object)endpoints);
        return endpoints;
    }

    public void initWithNiwsConfig(IClientConfig iClientConfig) {
        this.serviceId = iClientConfig.getClientName();
        this.serverListCache = new CseServerListCacheWrapper(this.config.getAppID(), this.serviceId, this.config.getVersionRule(this.serviceId), "rest");
    }
}

