/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.springboot.starter.discovery;

import io.servicecomb.core.provider.consumer.ConsumerProviderManager;
import io.servicecomb.core.provider.consumer.ReferenceConfig;
import io.servicecomb.foundation.common.net.URIEndpointObject;
import io.servicecomb.serviceregistry.RegistryUtils;
import io.servicecomb.serviceregistry.api.registry.Microservice;
import io.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import io.servicecomb.serviceregistry.client.ServiceRegistryClient;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public class CseDiscoveryClient
implements DiscoveryClient {
    @Inject
    private ConsumerProviderManager consumerProviderManager;

    public String description() {
        return "Spring Cloud CSE Discovery Client";
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        ReferenceConfig referenceConfig;
        String versionRule;
        String appId;
        String cseServiceID;
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        ServiceRegistryClient client = RegistryUtils.getServiceRegistryClient();
        List cseServices = client.getMicroserviceInstance(cseServiceID = client.getMicroserviceId(appId = RegistryUtils.getAppId(), serviceId, versionRule = (referenceConfig = this.consumerProviderManager.getReferenceConfig(serviceId)).getMicroserviceVersionRule()), cseServiceID);
        if (null != cseServices && !cseServices.isEmpty()) {
            for (MicroserviceInstance instance : cseServices) {
                List eps = instance.getEndpoints();
                for (String ep : eps) {
                    URIEndpointObject uri = new URIEndpointObject(ep);
                    instances.add((ServiceInstance)new DefaultServiceInstance(instance.getServiceId(), uri.getHostOrIp(), uri.getPort(), false));
                }
            }
        }
        return instances;
    }

    public ServiceInstance getLocalServiceInstance() {
        return null;
    }

    public List<String> getServices() {
        ServiceRegistryClient client = RegistryUtils.getServiceRegistryClient();
        List services = client.getAllMicroservices();
        ArrayList<String> serviceIDList = new ArrayList<String>();
        if (null != services && !services.isEmpty()) {
            for (Microservice service : services) {
                serviceIDList.add(service.getServiceName());
            }
        }
        return serviceIDList;
    }
}

