/*
 * Copyright 2017 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.servicecomb.springboot.starter.discovery;

import io.servicecomb.core.provider.consumer.ConsumerProviderManager;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.noop.NoopDiscoveryClientAutoConfiguration;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@AutoConfigureBefore(NoopDiscoveryClientAutoConfiguration.class)
@Configuration
public class CseDiscoveryClientConfiguration {

    @Bean
    public CseDiscoveryProperties cseDiscoveryProperties() {
        return new CseDiscoveryProperties();
    }

    @Bean
    @ConditionalOnBean(ZuulProperties.class)
    public CseRoutesProperties cseRoutesProperties(ConsumerProviderManager manager) {
        return new CseRoutesProperties(manager);
    }

    @Bean
    @Primary
    public DiscoveryClient cseDiscoveryClient() {
        return new CseDiscoveryClient();
    }

}
