/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.springboot.starter.configuration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.configuration.AbstractConfiguration;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;

public class ConfigurableEnvironmentConfiguration
extends AbstractConfiguration {
    private final ConfigurableEnvironment environment;

    public ConfigurableEnvironmentConfiguration(ConfigurableEnvironment environment) {
        this.environment = environment;
    }

    protected void addPropertyDirect(String key, Object value) {
    }

    public boolean isEmpty() {
        return !this.getKeys().hasNext();
    }

    public boolean containsKey(String key) {
        return this.environment.containsProperty(key);
    }

    public Object getProperty(String key) {
        return this.environment.getProperty(key);
    }

    public Iterator<String> getKeys() {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, PropertySource<?>> entry : this.getPropertySources().entrySet()) {
            PropertySource<?> source = entry.getValue();
            if (!(source instanceof EnumerablePropertySource)) continue;
            EnumerablePropertySource enumerable = (EnumerablePropertySource)source;
            for (String name : enumerable.getPropertyNames()) {
                result.add(name);
            }
        }
        return result.iterator();
    }

    private Map<String, PropertySource<?>> getPropertySources() {
        LinkedHashMap map = new LinkedHashMap();
        MutablePropertySources sources = this.environment != null ? this.environment.getPropertySources() : new StandardEnvironment().getPropertySources();
        for (PropertySource source : sources) {
            this.extract("", map, source);
        }
        return map;
    }

    private void extract(String root, Map<String, PropertySource<?>> map, PropertySource<?> source) {
        if (source instanceof CompositePropertySource) {
            for (PropertySource nest : ((CompositePropertySource)source).getPropertySources()) {
                this.extract(source.getName() + ":", map, nest);
            }
        } else {
            map.put(root + source.getName(), source);
        }
    }
}

