/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.springboot.starter.configuration;

import com.netflix.config.ConcurrentCompositeConfiguration;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DeploymentContext;
import com.netflix.config.DynamicProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicURLConfiguration;
import io.servicecomb.springboot.starter.configuration.ConfigurableEnvironmentConfiguration;
import io.servicecomb.springboot.starter.configuration.CseEndpoint;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PreDestroy;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.ConfigurationBuilder;
import org.apache.commons.configuration.EnvironmentConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.util.ReflectionUtils;

@Configuration
@ConditionalOnClass(value={ConcurrentCompositeConfiguration.class, ConfigurationBuilder.class})
public class CseAutoConfiguration {
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean(false);
    @Autowired
    private ConfigurableEnvironment env;
    @Autowired(required=false)
    private List<AbstractConfiguration> externalConfigurations = new ArrayList<AbstractConfiguration>();

    @PreDestroy
    public void close() {
        CseAutoConfiguration.setStatic(ConfigurationManager.class, "instance", null);
        CseAutoConfiguration.setStatic(ConfigurationManager.class, "customConfigurationInstalled", false);
        CseAutoConfiguration.setStatic(DynamicPropertyFactory.class, "config", null);
        CseAutoConfiguration.setStatic(DynamicPropertyFactory.class, "initializedWithDefaultConfig", false);
        CseAutoConfiguration.setStatic(DynamicProperty.class, "dynamicPropertySupportImpl", null);
        INITIALIZED.compareAndSet(true, false);
    }

    @Bean
    public ConfigurableEnvironmentConfiguration configurableEnvironmentConfiguration() {
        ConfigurableEnvironmentConfiguration envConfig = new ConfigurableEnvironmentConfiguration(this.env);
        this.configureArchaius(envConfig);
        return envConfig;
    }

    protected void configureArchaius(ConfigurableEnvironmentConfiguration envConfig) {
        if (INITIALIZED.compareAndSet(false, true)) {
            String appName = this.env.getProperty("spring.application.name");
            if (appName == null) {
                appName = "application";
            }
            System.setProperty(DeploymentContext.ContextKey.appId.getKey(), appName);
            ConcurrentCompositeConfiguration config = new ConcurrentCompositeConfiguration();
            if (this.externalConfigurations != null) {
                for (AbstractConfiguration externalConfig : this.externalConfigurations) {
                    config.addConfiguration(externalConfig);
                }
            }
            config.addConfiguration((AbstractConfiguration)envConfig, ConfigurableEnvironmentConfiguration.class.getSimpleName());
            DynamicURLConfiguration defaultURLConfig = new DynamicURLConfiguration();
            try {
                config.addConfiguration((AbstractConfiguration)defaultURLConfig, "archaius.dynamicPropertyFactory.URL_CONFIG");
            }
            catch (Throwable externalConfig) {
                // empty catch block
            }
            if (!Boolean.getBoolean("archaius.dynamicProperty.disableSystemConfig")) {
                SystemConfiguration sysConfig = new SystemConfiguration();
                config.addConfiguration((AbstractConfiguration)sysConfig, "archaius.dynamicPropertyFactory.SYS_CONFIG");
            }
            if (!Boolean.getBoolean("archaius.dynamicProperty.disableEnvironmentConfig")) {
                EnvironmentConfiguration environmentConfiguration = new EnvironmentConfiguration();
                config.addConfiguration((AbstractConfiguration)environmentConfiguration, "archaius.dynamicPropertyFactory.ENV_CONFIG");
            }
            ConcurrentCompositeConfiguration appOverrideConfig = new ConcurrentCompositeConfiguration();
            config.addConfiguration((AbstractConfiguration)appOverrideConfig, "APPLICATION_PROPERTIES");
            config.setContainerConfigurationIndex(config.getIndexOfConfiguration((AbstractConfiguration)appOverrideConfig));
            this.addArchaiusConfiguration(config);
        }
    }

    private void addArchaiusConfiguration(ConcurrentCompositeConfiguration config) {
        if (ConfigurationManager.isConfigurationInstalled()) {
            AbstractConfiguration installedConfiguration = ConfigurationManager.getConfigInstance();
            if (installedConfiguration instanceof ConcurrentCompositeConfiguration) {
                ConcurrentCompositeConfiguration configInstance = (ConcurrentCompositeConfiguration)installedConfiguration;
                configInstance.addConfiguration((AbstractConfiguration)config);
            } else {
                installedConfiguration.append((org.apache.commons.configuration.Configuration)config);
            }
        } else {
            ConfigurationManager.install((AbstractConfiguration)config);
        }
    }

    private static void setStatic(Class<?> type, String name, Object value) {
        Field field = ReflectionUtils.findField(type, (String)name);
        ReflectionUtils.makeAccessible((Field)field);
        ReflectionUtils.setField((Field)field, null, (Object)value);
    }

    @Configuration
    @ConditionalOnProperty(value={"archaius.propagate.environmentChangedEvent"}, matchIfMissing=true)
    @ConditionalOnClass(value={EnvironmentChangeEvent.class})
    protected static class PropagateEventsConfiguration
    implements ApplicationListener<EnvironmentChangeEvent> {
        @Autowired
        private Environment env;

        protected PropagateEventsConfiguration() {
        }

        public void onApplicationEvent(EnvironmentChangeEvent event) {
            AbstractConfiguration manager = ConfigurationManager.getConfigInstance();
            for (String key : event.getKeys()) {
                for (ConfigurationListener listener : manager.getConfigurationListeners()) {
                    Object source = event.getSource();
                    int type = 3;
                    String value = this.env.getProperty(key);
                    boolean beforeUpdate = false;
                    listener.configurationChanged(new ConfigurationEvent(source, type, key, (Object)value, beforeUpdate));
                }
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={Endpoint.class})
    protected static class ArchaiusEndpointConfiguration {
        protected ArchaiusEndpointConfiguration() {
        }

        @Bean
        @ConditionalOnEnabledEndpoint(value="archaius")
        protected CseEndpoint archaiusEndpoint() {
            return new CseEndpoint();
        }
    }
}

