/*
 * Copyright 2017 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.servicecomb.springboot.starter.configuration;

import org.apache.commons.configuration.AbstractConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

import com.netflix.config.ConfigurationManager;

/**
 *
 */
public final class CseDelegatingProxyUtils {

    private static final String APPLICATION_CONTEXT = ApplicationContext.class.getName();

    private CseDelegatingProxyUtils() {
    }

    public static <T> T getNamedInstance(Class<T> type, String name) {
        ApplicationContext context = (ApplicationContext) ConfigurationManager
                .getConfigInstance().getProperty(APPLICATION_CONTEXT);
        return context != null && context.containsBean(name) ? context
                .getBean(name, type) : null;
    }

    public static <T> T getInstanceWithPrefix(Class<T> type, String prefix) {
        String name = prefix + type.getSimpleName();
        return getNamedInstance(type, name);
    }

    public static void addApplicationContext(ConfigurableApplicationContext context) {
        AbstractConfiguration config = ConfigurationManager.getConfigInstance();
        config.clearProperty(APPLICATION_CONTEXT);
        config.setProperty(APPLICATION_CONTEXT, context);
    }

}
