/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client;

import io.servicecomb.provider.springmvc.reference.CseClientHttpRequest;
import io.servicecomb.provider.springmvc.reference.CseClientHttpResponse;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.client.MessageBodyClientHttpResponseWrapper;

public class CseHttpMessageConverter
implements HttpMessageConverter<Object> {
    private static final List<MediaType> ALL_MEDIA_TYPE = Arrays.asList(MediaType.ALL);
    private static final Field RESPONSE_FIELD = ReflectionUtils.findField(MessageBodyClientHttpResponseWrapper.class, (String)"response");

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return true;
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return true;
    }

    public List<MediaType> getSupportedMediaTypes() {
        return ALL_MEDIA_TYPE;
    }

    public Object read(Class<? extends Object> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        MessageBodyClientHttpResponseWrapper respWrapper = (MessageBodyClientHttpResponseWrapper)inputMessage;
        CseClientHttpResponse resp = (CseClientHttpResponse)ReflectionUtils.getField((Field)RESPONSE_FIELD, (Object)respWrapper);
        return resp.getResult();
    }

    public void write(Object t, MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        CseClientHttpRequest request = (CseClientHttpRequest)outputMessage;
        request.setRequestBody(t);
    }

    static {
        RESPONSE_FIELD.setAccessible(true);
    }
}

