/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.provider.springmvc.reference;

import io.netty.handler.codec.http.QueryStringDecoder;
import io.servicecomb.common.rest.codec.RestCodec;
import io.servicecomb.common.rest.definition.RestOperationMeta;
import io.servicecomb.common.rest.locator.OperationLocator;
import io.servicecomb.common.rest.locator.ServicePathManager;
import io.servicecomb.core.Invocation;
import io.servicecomb.core.definition.MicroserviceMeta;
import io.servicecomb.core.definition.OperationMeta;
import io.servicecomb.core.invocation.InvocationFactory;
import io.servicecomb.core.provider.consumer.InvokerUtils;
import io.servicecomb.core.provider.consumer.ReferenceConfig;
import io.servicecomb.core.provider.consumer.ReferenceConfigUtils;
import io.servicecomb.provider.springmvc.reference.CommonToHttpServletRequest;
import io.servicecomb.provider.springmvc.reference.CseClientHttpResponse;
import io.servicecomb.provider.springmvc.reference.RequestMeta;
import io.servicecomb.swagger.invocation.Response;
import io.servicecomb.swagger.invocation.context.InvocationContext;
import io.servicecomb.swagger.invocation.exception.ExceptionFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;

public class CseClientHttpRequest
implements ClientHttpRequest {
    private URI uri;
    private String path;
    private HttpMethod method;
    private HttpHeaders httpHeaders = new HttpHeaders();
    private InvocationContext context;
    private Object requestBody;
    private Map<String, List<String>> queryParams;
    private RequestMeta requestMeta;

    public CseClientHttpRequest() {
    }

    public CseClientHttpRequest(URI uri, HttpMethod method) {
        this.uri = uri;
        this.method = method;
    }

    public InvocationContext getContext() {
        return this.context;
    }

    public void setContext(InvocationContext context) {
        this.context = context;
    }

    public void setRequestBody(Object requestBody) {
        this.requestBody = requestBody;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public URI getURI() {
        return this.uri;
    }

    public HttpHeaders getHeaders() {
        return this.httpHeaders;
    }

    public OutputStream getBody() throws IOException {
        return null;
    }

    public ClientHttpResponse execute() throws IOException {
        this.path = this.findUriPath(this.uri);
        this.requestMeta = this.createRequestMeta(this.method.name(), this.uri);
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(this.uri.getRawSchemeSpecificPart());
        this.queryParams = queryStringDecoder.parameters();
        Object[] args = this.collectArguments();
        return this.invoke(args);
    }

    private RequestMeta createRequestMeta(String httpMetod, URI uri) {
        String microserviceName = uri.getAuthority();
        ReferenceConfig referenceConfig = ReferenceConfigUtils.getForInvoke((String)microserviceName);
        MicroserviceMeta microserviceMeta = referenceConfig.getMicroserviceMeta();
        ServicePathManager servicePathManager = ServicePathManager.getServicePathManager((MicroserviceMeta)microserviceMeta);
        if (servicePathManager == null) {
            throw new Error(String.format("no schema defined for %s:%s", microserviceMeta.getAppId(), microserviceMeta.getName()));
        }
        OperationLocator locator = servicePathManager.consumerLocateOperation(this.path, httpMetod);
        RestOperationMeta swaggerRestOperation = locator.getOperation();
        Map pathParams = locator.getPathVarMap();
        return new RequestMeta(referenceConfig, swaggerRestOperation, pathParams);
    }

    protected String findUriPath(URI uri) {
        return uri.getRawPath();
    }

    private CseClientHttpResponse invoke(Object[] args) {
        Invocation invocation = InvocationFactory.forConsumer((ReferenceConfig)this.requestMeta.getReferenceConfig(), (OperationMeta)this.requestMeta.getOperationMeta(), (Object[])args);
        invocation.getHandlerContext().put("rest-client-request-path", this.path + "?" + this.uri.getRawQuery());
        if (this.context != null) {
            invocation.addContext(this.context);
        }
        invocation.getHandlerContext().put("servicecomb-rest-consumer-header", this.httpHeaders);
        Response response = this.doInvoke(invocation);
        if (response.isSuccessed()) {
            return new CseClientHttpResponse(response);
        }
        throw ExceptionFactory.convertConsumerException((Throwable)((Throwable)response.getResult()));
    }

    protected Response doInvoke(Invocation invocation) {
        return InvokerUtils.innerSyncInvoke((Invocation)invocation);
    }

    private Object[] collectArguments() {
        CommonToHttpServletRequest mockRequest = new CommonToHttpServletRequest(this.requestMeta.getPathParams(), this.queryParams, (Map<String, List<String>>)this.httpHeaders, this.requestBody, this.requestMeta.getSwaggerRestOperation().isFormData());
        return RestCodec.restToArgs((HttpServletRequest)mockRequest, (RestOperationMeta)this.requestMeta.getSwaggerRestOperation());
    }
}

