/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.provider.springmvc.reference;

import io.servicecomb.foundation.vertx.http.AbstractHttpServletRequest;
import java.io.IOException;
import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;

public class CommonToHttpServletRequest
extends AbstractHttpServletRequest {
    private Map<String, List<String>> queryParams;
    private Map<String, List<String>> httpHeaders;
    private Cookie[] cookies;

    public CommonToHttpServletRequest(Map<String, String> pathParams, Map<String, List<String>> queryParams, Map<String, List<String>> httpHeaders, Object bodyObject, boolean isFormData) {
        this.setAttribute("servicecomb-paths", pathParams);
        if (isFormData) {
            this.setAttribute("servicecomb-forms", (Map)bodyObject);
        } else {
            this.setAttribute("servicecomb-body", bodyObject);
        }
        this.queryParams = queryParams;
        this.httpHeaders = httpHeaders;
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public String getParameter(String name) {
        List<String> queryValues = this.queryParams.get(name);
        if (queryValues == null || queryValues.isEmpty()) {
            return null;
        }
        return queryValues.get(0);
    }

    public String[] getParameterValues(String name) {
        List<String> queryValues = this.queryParams.get(name);
        if (queryValues == null || queryValues.isEmpty()) {
            return null;
        }
        return queryValues.toArray(new String[queryValues.size()]);
    }

    public String getHeader(String name) {
        List<String> headerValues = this.httpHeaders.get(name);
        if (headerValues == null || headerValues.isEmpty()) {
            return null;
        }
        return headerValues.get(0);
    }

    public Enumeration<String> getHeaders(String name) {
        List<String> headerValues = this.httpHeaders.get(name);
        if (headerValues == null || headerValues.isEmpty()) {
            return Collections.emptyEnumeration();
        }
        return Collections.enumeration(headerValues);
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.httpHeaders.keySet());
    }

    public Cookie[] getCookies() {
        if (this.cookies == null) {
            this.cookies = this.createCookies();
        }
        return this.cookies;
    }

    private Cookie[] createCookies() {
        List<String> strCookies = this.httpHeaders.get("Cookie");
        if (strCookies == null) {
            return new Cookie[0];
        }
        ArrayList<Cookie> result = new ArrayList<Cookie>();
        for (String strCookie : strCookies) {
            List<HttpCookie> httpCookies = HttpCookie.parse(strCookie);
            for (HttpCookie httpCookie : httpCookies) {
                Cookie cookie = new Cookie(httpCookie.getName(), httpCookie.getValue());
                result.add(cookie);
            }
        }
        return result.toArray(new Cookie[result.size()]);
    }

    public ServletInputStream getInputStream() throws IOException {
        return null;
    }

    public void setHeader(String name, String value) {
        this.httpHeaders.put(name, Arrays.asList(value));
    }

    public void addHeader(String name, String value) {
        List list = this.httpHeaders.computeIfAbsent(name, key -> new ArrayList());
        list.add(value);
    }
}

