/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.provider.springmvc.reference;

import io.servicecomb.provider.springmvc.reference.AcceptableRestTemplate;
import io.servicecomb.provider.springmvc.reference.CseRestTemplate;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriTemplateHandler;

class RestTemplateWrapper
extends RestTemplate {
    private final List<AcceptableRestTemplate> acceptableRestTemplates = new ArrayList<AcceptableRestTemplate>();
    final RestTemplate defaultRestTemplate = new RestTemplate();

    RestTemplateWrapper() {
        this.acceptableRestTemplates.add(new CseRestTemplate());
    }

    void addAcceptableRestTemplate(AcceptableRestTemplate restTemplate) {
        this.acceptableRestTemplates.add(restTemplate);
    }

    RestTemplate getRestTemplate(String url) {
        for (AcceptableRestTemplate template : this.acceptableRestTemplates) {
            if (!template.isAcceptable(url)) continue;
            return template;
        }
        return this.defaultRestTemplate;
    }

    RestTemplate getRestTemplate(URI uri) {
        for (AcceptableRestTemplate template : this.acceptableRestTemplates) {
            if (!template.isAcceptable(uri)) continue;
            return template;
        }
        return this.defaultRestTemplate;
    }

    public <T> T getForObject(String url, Class<T> responseType, Object ... urlVariables) throws RestClientException {
        return (T)this.getRestTemplate(url).getForObject(url, responseType, urlVariables);
    }

    public <T> T getForObject(String url, Class<T> responseType, Map<String, ?> urlVariables) throws RestClientException {
        return (T)this.getRestTemplate(url).getForObject(url, responseType, urlVariables);
    }

    public <T> T getForObject(URI url, Class<T> responseType) throws RestClientException {
        return (T)this.getRestTemplate(url).getForObject(url, responseType);
    }

    public <T> ResponseEntity<T> getForEntity(String url, Class<T> responseType, Object ... urlVariables) throws RestClientException {
        return this.getRestTemplate(url).getForEntity(url, responseType, urlVariables);
    }

    public <T> ResponseEntity<T> getForEntity(String url, Class<T> responseType, Map<String, ?> urlVariables) throws RestClientException {
        return this.getRestTemplate(url).getForEntity(url, responseType, urlVariables);
    }

    public <T> ResponseEntity<T> getForEntity(URI url, Class<T> responseType) throws RestClientException {
        return this.getRestTemplate(url).getForEntity(url, responseType);
    }

    public <T> T postForObject(String url, Object request, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        return (T)this.getRestTemplate(url).postForObject(url, request, responseType, uriVariables);
    }

    public <T> T postForObject(String url, Object request, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        return (T)this.getRestTemplate(url).postForObject(url, request, responseType, uriVariables);
    }

    public <T> T postForObject(URI url, Object request, Class<T> responseType) throws RestClientException {
        return (T)this.getRestTemplate(url).postForObject(url, request, responseType);
    }

    public <T> ResponseEntity<T> postForEntity(String url, Object request, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        return this.getRestTemplate(url).postForEntity(url, request, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> postForEntity(String url, Object request, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        return this.getRestTemplate(url).postForEntity(url, request, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> postForEntity(URI url, Object request, Class<T> responseType) throws RestClientException {
        return this.getRestTemplate(url).postForEntity(url, request, responseType);
    }

    public void put(String url, Object request, Object ... urlVariables) throws RestClientException {
        this.getRestTemplate(url).put(url, request, urlVariables);
    }

    public void put(String url, Object request, Map<String, ?> urlVariables) throws RestClientException {
        this.getRestTemplate(url).put(url, request, urlVariables);
    }

    public void put(URI url, Object request) throws RestClientException {
        this.getRestTemplate(url).put(url, request);
    }

    public void delete(String url, Object ... urlVariables) throws RestClientException {
        this.getRestTemplate(url).delete(url, urlVariables);
    }

    public void delete(String url, Map<String, ?> urlVariables) throws RestClientException {
        this.getRestTemplate(url).delete(url, urlVariables);
    }

    public void delete(URI url) throws RestClientException {
        this.getRestTemplate(url).delete(url);
    }

    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, HttpEntity<?> requestEntity, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        return this.getRestTemplate(url).exchange(url, method, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, HttpEntity<?> requestEntity, ParameterizedTypeReference<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        return this.getRestTemplate(url).exchange(url, method, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, HttpEntity<?> requestEntity, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        return this.getRestTemplate(url).exchange(url, method, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, HttpEntity<?> requestEntity, ParameterizedTypeReference<T> responseType, Object ... uriVariables) throws RestClientException {
        return this.getRestTemplate(url).exchange(url, method, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> exchange(RequestEntity<?> requestEntity, Class<T> responseType) throws RestClientException {
        return this.getRestTemplate(requestEntity.getUrl()).exchange(requestEntity, responseType);
    }

    public <T> ResponseEntity<T> exchange(RequestEntity<?> requestEntity, ParameterizedTypeReference<T> responseType) throws RestClientException {
        return this.getRestTemplate(requestEntity.getUrl()).exchange(requestEntity, responseType);
    }

    public <T> ResponseEntity<T> exchange(URI url, HttpMethod method, HttpEntity<?> requestEntity, Class<T> responseType) throws RestClientException {
        return this.getRestTemplate(url).exchange(url, method, requestEntity, responseType);
    }

    public <T> ResponseEntity<T> exchange(URI url, HttpMethod method, HttpEntity<?> requestEntity, ParameterizedTypeReference<T> responseType) throws RestClientException {
        return this.getRestTemplate(url).exchange(url, method, requestEntity, responseType);
    }

    public HttpHeaders headForHeaders(String url, Object ... urlVariables) throws RestClientException {
        return this.getRestTemplate(url).headForHeaders(url, urlVariables);
    }

    public HttpHeaders headForHeaders(String url, Map<String, ?> urlVariables) throws RestClientException {
        return this.getRestTemplate(url).headForHeaders(url, urlVariables);
    }

    public HttpHeaders headForHeaders(URI url) throws RestClientException {
        return this.getRestTemplate(url).headForHeaders(url);
    }

    public URI postForLocation(String url, Object request, Object ... urlVariables) throws RestClientException {
        return this.getRestTemplate(url).postForLocation(url, request, urlVariables);
    }

    public URI postForLocation(String url, Object request, Map<String, ?> urlVariables) throws RestClientException {
        return this.getRestTemplate(url).postForLocation(url, request, urlVariables);
    }

    public URI postForLocation(URI url, Object request) throws RestClientException {
        return this.getRestTemplate(url).postForLocation(url, request);
    }

    public Set<HttpMethod> optionsForAllow(String url, Object ... urlVariables) throws RestClientException {
        return this.getRestTemplate(url).optionsForAllow(url, urlVariables);
    }

    public Set<HttpMethod> optionsForAllow(String url, Map<String, ?> urlVariables) throws RestClientException {
        return this.getRestTemplate(url).optionsForAllow(url, urlVariables);
    }

    public Set<HttpMethod> optionsForAllow(URI url) throws RestClientException {
        return this.getRestTemplate(url).optionsForAllow(url);
    }

    public <T> T execute(String url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor, Object ... urlVariables) throws RestClientException {
        return (T)this.getRestTemplate(url).execute(url, method, requestCallback, responseExtractor, urlVariables);
    }

    public <T> T execute(String url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor, Map<String, ?> urlVariables) throws RestClientException {
        return (T)this.getRestTemplate(url).execute(url, method, requestCallback, responseExtractor, urlVariables);
    }

    public <T> T execute(URI url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor) throws RestClientException {
        return (T)this.getRestTemplate(url).execute(url, method, requestCallback, responseExtractor);
    }

    public void setInterceptors(List<ClientHttpRequestInterceptor> interceptors) {
        super.setInterceptors(interceptors);
        this.defaultRestTemplate.setInterceptors(interceptors);
    }

    public void setRequestFactory(ClientHttpRequestFactory requestFactory) {
        super.setRequestFactory(requestFactory);
        this.defaultRestTemplate.setRequestFactory(requestFactory);
    }

    public void setErrorHandler(ResponseErrorHandler errorHandler) {
        super.setErrorHandler(errorHandler);
        this.acceptableRestTemplates.forEach(template -> template.setErrorHandler(errorHandler));
        this.defaultRestTemplate.setErrorHandler(errorHandler);
    }

    public void setDefaultUriVariables(Map<String, ?> defaultUriVariables) {
        super.setDefaultUriVariables(defaultUriVariables);
        this.acceptableRestTemplates.forEach(template -> template.setDefaultUriVariables(defaultUriVariables));
        this.defaultRestTemplate.setDefaultUriVariables(defaultUriVariables);
    }

    public void setUriTemplateHandler(UriTemplateHandler handler) {
        super.setUriTemplateHandler(handler);
        this.defaultRestTemplate.setUriTemplateHandler(handler);
    }

    public void setMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        super.setMessageConverters(messageConverters);
        this.defaultRestTemplate.setMessageConverters(messageConverters);
    }
}

