/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.provider.springmvc.reference;

import io.servicecomb.provider.springmvc.reference.CseRestTemplate;
import java.net.URI;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class RestTemplateWrapper
extends RestTemplate {
    private static RestTemplate cseRestTemplate = new CseRestTemplate();

    private boolean isCse(String url) {
        return url.startsWith("cse://");
    }

    private boolean isCse(URI uri) {
        return "cse".equals(uri.getScheme());
    }

    public <T> T getForObject(String url, Class<T> responseType, Object ... urlVariables) throws RestClientException {
        if (this.isCse(url)) {
            return (T)cseRestTemplate.getForObject(url, responseType, urlVariables);
        }
        return (T)super.getForObject(url, responseType, urlVariables);
    }

    public <T> T getForObject(String url, Class<T> responseType, Map<String, ?> urlVariables) throws RestClientException {
        if (this.isCse(url)) {
            return (T)cseRestTemplate.getForObject(url, responseType, urlVariables);
        }
        return (T)super.getForObject(url, responseType, urlVariables);
    }

    public <T> T getForObject(URI url, Class<T> responseType) throws RestClientException {
        if (this.isCse(url)) {
            return (T)cseRestTemplate.getForObject(url, responseType);
        }
        return (T)super.getForObject(url, responseType);
    }

    public <T> ResponseEntity<T> getForEntity(String url, Class<T> responseType, Object ... urlVariables) throws RestClientException {
        if (this.isCse(url)) {
            return cseRestTemplate.getForEntity(url, responseType, urlVariables);
        }
        return super.getForEntity(url, responseType, urlVariables);
    }

    public <T> ResponseEntity<T> getForEntity(String url, Class<T> responseType, Map<String, ?> urlVariables) throws RestClientException {
        if (this.isCse(url)) {
            return cseRestTemplate.getForEntity(url, responseType, urlVariables);
        }
        return super.getForEntity(url, responseType, urlVariables);
    }

    public <T> ResponseEntity<T> getForEntity(URI url, Class<T> responseType) throws RestClientException {
        if (this.isCse(url)) {
            return cseRestTemplate.getForEntity(url, responseType);
        }
        return super.getForEntity(url, responseType);
    }

    public <T> T postForObject(String url, Object request, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        if (this.isCse(url)) {
            return (T)cseRestTemplate.postForObject(url, request, responseType, uriVariables);
        }
        return (T)super.postForObject(url, request, responseType, uriVariables);
    }

    public <T> T postForObject(String url, Object request, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        if (this.isCse(url)) {
            return (T)cseRestTemplate.postForObject(url, request, responseType, uriVariables);
        }
        return (T)super.postForObject(url, request, responseType, uriVariables);
    }

    public <T> T postForObject(URI url, Object request, Class<T> responseType) throws RestClientException {
        if (this.isCse(url)) {
            return (T)cseRestTemplate.postForObject(url, request, responseType);
        }
        return (T)super.postForObject(url, request, responseType);
    }

    public <T> ResponseEntity<T> postForEntity(String url, Object request, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        if (this.isCse(url)) {
            return cseRestTemplate.postForEntity(url, request, responseType, uriVariables);
        }
        return super.postForEntity(url, request, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> postForEntity(String url, Object request, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        if (this.isCse(url)) {
            return cseRestTemplate.postForEntity(url, request, responseType, uriVariables);
        }
        return super.postForEntity(url, request, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> postForEntity(URI url, Object request, Class<T> responseType) throws RestClientException {
        if (this.isCse(url)) {
            return cseRestTemplate.postForEntity(url, request, responseType);
        }
        return super.postForEntity(url, request, responseType);
    }

    public void put(String url, Object request, Object ... urlVariables) throws RestClientException {
        if (this.isCse(url)) {
            cseRestTemplate.put(url, request, urlVariables);
            return;
        }
        super.put(url, request, urlVariables);
    }

    public void put(String url, Object request, Map<String, ?> urlVariables) throws RestClientException {
        if (this.isCse(url)) {
            cseRestTemplate.put(url, request, urlVariables);
            return;
        }
        super.put(url, request, urlVariables);
    }

    public void put(URI url, Object request) throws RestClientException {
        if (this.isCse(url)) {
            cseRestTemplate.put(url, request);
            return;
        }
        super.put(url, request);
    }

    public void delete(String url, Object ... urlVariables) throws RestClientException {
        if (this.isCse(url)) {
            cseRestTemplate.delete(url, urlVariables);
            return;
        }
        super.delete(url, urlVariables);
    }

    public void delete(String url, Map<String, ?> urlVariables) throws RestClientException {
        if (this.isCse(url)) {
            cseRestTemplate.delete(url, urlVariables);
            return;
        }
        super.delete(url, urlVariables);
    }

    public void delete(URI url) throws RestClientException {
        if (this.isCse(url)) {
            cseRestTemplate.delete(url);
            return;
        }
        super.delete(url);
    }

    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, HttpEntity<?> requestEntity, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        if (this.isCse(url)) {
            return cseRestTemplate.exchange(url, method, requestEntity, responseType, uriVariables);
        }
        return super.exchange(url, method, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, HttpEntity<?> requestEntity, ParameterizedTypeReference<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        if (this.isCse(url)) {
            return cseRestTemplate.exchange(url, method, requestEntity, responseType, uriVariables);
        }
        return super.exchange(url, method, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, HttpEntity<?> requestEntity, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        if (this.isCse(url)) {
            return cseRestTemplate.exchange(url, method, requestEntity, responseType, uriVariables);
        }
        return super.exchange(url, method, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, HttpEntity<?> requestEntity, ParameterizedTypeReference<T> responseType, Object ... uriVariables) throws RestClientException {
        if (this.isCse(url)) {
            return cseRestTemplate.exchange(url, method, requestEntity, responseType, uriVariables);
        }
        return super.exchange(url, method, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> exchange(RequestEntity<?> requestEntity, Class<T> responseType) throws RestClientException {
        if (this.isCse(requestEntity.getUrl())) {
            return cseRestTemplate.exchange(requestEntity, responseType);
        }
        return super.exchange(requestEntity, responseType);
    }

    public <T> ResponseEntity<T> exchange(RequestEntity<?> requestEntity, ParameterizedTypeReference<T> responseType) throws RestClientException {
        if (this.isCse(requestEntity.getUrl())) {
            return cseRestTemplate.exchange(requestEntity, responseType);
        }
        return super.exchange(requestEntity, responseType);
    }

    public <T> ResponseEntity<T> exchange(URI url, HttpMethod method, HttpEntity<?> requestEntity, Class<T> responseType) throws RestClientException {
        if (this.isCse(url)) {
            return cseRestTemplate.exchange(url, method, requestEntity, responseType);
        }
        return super.exchange(url, method, requestEntity, responseType);
    }

    public <T> ResponseEntity<T> exchange(URI url, HttpMethod method, HttpEntity<?> requestEntity, ParameterizedTypeReference<T> responseType) throws RestClientException {
        if (this.isCse(url)) {
            return cseRestTemplate.exchange(url, method, requestEntity, responseType);
        }
        return super.exchange(url, method, requestEntity, responseType);
    }
}

