/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.provider.springmvc.reference;

import io.servicecomb.provider.springmvc.reference.CseClientHttpRequestFactory;
import io.servicecomb.provider.springmvc.reference.CseRequestCallback;
import io.servicecomb.provider.springmvc.reference.CseUriTemplateHandler;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.springframework.web.client.CseHttpMessageConverter;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriTemplateHandler;

public class CseRestTemplate
extends RestTemplate {
    public CseRestTemplate() {
        this.setMessageConverters(Arrays.asList(new CseHttpMessageConverter()));
        this.setRequestFactory(new CseClientHttpRequestFactory());
        this.setUriTemplateHandler((UriTemplateHandler)new CseUriTemplateHandler());
    }

    protected <T> RequestCallback httpEntityCallback(Object requestBody) {
        RequestCallback callback = super.httpEntityCallback(requestBody);
        CseRequestCallback cseCallback = new CseRequestCallback(requestBody, callback);
        return cseCallback;
    }

    protected <T> RequestCallback httpEntityCallback(Object requestBody, Type responseType) {
        RequestCallback callback = super.httpEntityCallback(requestBody, responseType);
        CseRequestCallback cseCallback = new CseRequestCallback(requestBody, callback);
        return cseCallback;
    }
}

