/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.provider.springmvc.reference;

import io.netty.handler.codec.http.QueryStringDecoder;
import io.servicecomb.common.rest.codec.LocalRestServerRequest;
import io.servicecomb.common.rest.codec.RestServerRequest;
import io.servicecomb.common.rest.definition.RestOperationMeta;
import io.servicecomb.common.rest.definition.RestParam;
import io.servicecomb.common.rest.locator.OperationLocator;
import io.servicecomb.common.rest.locator.ServicePathManager;
import io.servicecomb.core.CseContext;
import io.servicecomb.core.Invocation;
import io.servicecomb.core.definition.MicroserviceMeta;
import io.servicecomb.core.definition.OperationMeta;
import io.servicecomb.core.invocation.InvocationFactory;
import io.servicecomb.core.provider.consumer.InvokerUtils;
import io.servicecomb.core.provider.consumer.ReferenceConfig;
import io.servicecomb.provider.springmvc.reference.CseClientHttpResponse;
import io.servicecomb.provider.springmvc.reference.RequestMeta;
import io.servicecomb.swagger.invocation.Response;
import io.servicecomb.swagger.invocation.context.InvocationContext;
import io.servicecomb.swagger.invocation.exception.ExceptionFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;

public class CseClientHttpRequest
extends OutputStream
implements ClientHttpRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(CseClientHttpRequest.class);
    private URI uri;
    private HttpMethod method;
    private HttpHeaders httpHeaders = new HttpHeaders();
    private InvocationContext context;
    private Object requestBody;

    public CseClientHttpRequest() {
    }

    public CseClientHttpRequest(URI uri, HttpMethod method) {
        this.uri = uri;
        this.method = method;
    }

    public InvocationContext getContext() {
        return this.context;
    }

    public void setContext(InvocationContext context) {
        this.context = context;
    }

    @Override
    public void write(int b) throws IOException {
        throw new Error("not support");
    }

    public void setRequestBody(Object requestBody) {
        this.requestBody = requestBody;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public URI getURI() {
        return this.uri;
    }

    public HttpHeaders getHeaders() {
        return this.httpHeaders;
    }

    public OutputStream getBody() throws IOException {
        return this;
    }

    public ClientHttpResponse execute() throws IOException {
        RequestMeta requestMeta = this.createRequestMeta(this.method.name(), this.uri);
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(this.uri.getRawSchemeSpecificPart());
        Map queryParams = queryStringDecoder.parameters();
        Object[] args = this.collectArguments(requestMeta, queryParams);
        return this.invoke(requestMeta, args);
    }

    private RequestMeta createRequestMeta(String httpMetod, URI uri) {
        String microserviceName = uri.getAuthority();
        ReferenceConfig referenceConfig = CseContext.getInstance().getConsumerProviderManager().getReferenceConfig(microserviceName);
        MicroserviceMeta microserviceMeta = referenceConfig.getMicroserviceMeta();
        ServicePathManager servicePathManager = ServicePathManager.getServicePathManager((MicroserviceMeta)microserviceMeta);
        if (servicePathManager == null) {
            throw new Error(String.format("no schema defined for %s:%s", microserviceMeta.getAppId(), microserviceMeta.getName()));
        }
        OperationLocator locator = servicePathManager.locateOperation(uri.getPath(), httpMetod);
        RestOperationMeta swaggerRestOperation = locator.getOperation();
        Map pathParams = locator.getPathVarMap();
        return new RequestMeta(referenceConfig, swaggerRestOperation, pathParams);
    }

    private CseClientHttpResponse invoke(RequestMeta requestMeta, Object[] args) {
        Response response;
        Invocation invocation = InvocationFactory.forConsumer((ReferenceConfig)requestMeta.getReferenceConfig(), (OperationMeta)requestMeta.getOperationMeta(), (Object[])args);
        invocation.getHandlerContext().put("rest-client-request-path", this.uri.getPath() + "?" + this.uri.getQuery());
        if (this.context != null) {
            invocation.addContext(this.context);
        }
        if ((response = this.doInvoke(invocation)).isSuccessed()) {
            return new CseClientHttpResponse(response);
        }
        throw ExceptionFactory.convertConsumerException((Throwable)((Throwable)response.getResult()));
    }

    protected Response doInvoke(Invocation invocation) {
        return InvokerUtils.innerSyncInvoke((Invocation)invocation);
    }

    private Object[] collectArguments(RequestMeta requestMeta, Map<String, List<String>> queryParams) {
        LocalRestServerRequest mockRequest = new LocalRestServerRequest(requestMeta.getPathParams(), queryParams, (Map)this.httpHeaders, this.requestBody);
        List paramList = requestMeta.getSwaggerRestOperation().getParamList();
        Object[] args = new Object[paramList.size()];
        for (int idx = 0; idx < paramList.size(); ++idx) {
            RestParam param = (RestParam)paramList.get(idx);
            try {
                args[idx] = param.getParamProcessor().getValue((RestServerRequest)mockRequest);
                continue;
            }
            catch (Exception e) {
                LOGGER.error("error arguments for operation " + requestMeta.getOperationMeta().getMicroserviceQualifiedName(), (Throwable)e);
                throw new Error(e);
            }
        }
        return args;
    }
}

