/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.core.transport;

import com.netflix.config.DynamicPropertyFactory;
import io.servicecomb.core.Endpoint;
import io.servicecomb.core.Transport;
import io.servicecomb.foundation.common.exceptions.ServiceCombException;
import io.servicecomb.foundation.common.net.NetUtils;
import io.servicecomb.foundation.common.net.URIEndpointObject;
import io.servicecomb.foundation.vertx.VertxUtils;
import io.servicecomb.serviceregistry.RegistryUtils;
import io.vertx.core.Vertx;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTransport
implements Transport {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTransport.class);
    public static final String ENDPOINT_KEY = "cse.endpoint";
    private static final long DEFAULT_TIMEOUT_MILLIS = 30000L;
    private static Long msReqeustTimeout = null;
    protected Vertx transportVertx = VertxUtils.getOrCreateVertxByName((String)"transport", null);
    protected Endpoint endpoint;
    protected Endpoint publishEndpoint;

    public static long getRequestTimeout() {
        if (msReqeustTimeout != null) {
            return msReqeustTimeout;
        }
        long msTimeout = DynamicPropertyFactory.getInstance().getLongProperty("cse.request.timeout", 30000L).get();
        if (msTimeout <= 0L) {
            msTimeout = 30000L;
        }
        msReqeustTimeout = msTimeout;
        return msReqeustTimeout;
    }

    @Override
    public Endpoint getPublishEndpoint() {
        return this.publishEndpoint;
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    protected void setListenAddressWithoutSchema(String addressWithoutSchema) {
        this.setListenAddressWithoutSchema(addressWithoutSchema, null);
    }

    protected void setListenAddressWithoutSchema(String addressWithoutSchema, Map<String, String> pairs) {
        addressWithoutSchema = this.genAddressWithoutSchema(addressWithoutSchema, pairs);
        this.endpoint = new Endpoint(this, NetUtils.getRealListenAddress((String)this.getName(), (String)addressWithoutSchema));
        this.publishEndpoint = this.endpoint.getEndpoint() != null ? new Endpoint(this, RegistryUtils.getPublishAddress((String)this.getName(), (String)addressWithoutSchema)) : null;
    }

    private String genAddressWithoutSchema(String addressWithoutSchema, Map<String, String> pairs) {
        if (addressWithoutSchema == null || pairs == null || pairs.isEmpty()) {
            return addressWithoutSchema;
        }
        int idx = addressWithoutSchema.indexOf(63);
        addressWithoutSchema = idx == -1 ? addressWithoutSchema + "?" : addressWithoutSchema + "&";
        String encodedQuery = URLEncodedUtils.format(pairs.entrySet().stream().map(entry -> new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList()), (String)StandardCharsets.UTF_8.name());
        addressWithoutSchema = !RegistryUtils.getServiceRegistry().getFeatures().isCanEncodeEndpoint() ? this.genAddressWithoutSchemaForOldSC(addressWithoutSchema, encodedQuery) : addressWithoutSchema + encodedQuery;
        return addressWithoutSchema;
    }

    private String genAddressWithoutSchemaForOldSC(String addressWithoutSchema, String encodedQuery) {
        try {
            LOGGER.warn("Service center do not support encoded query, so we use unencoded query, this caused not support chinese/space (and maybe other char) in query value.");
            String decodedQuery = URLDecoder.decode(encodedQuery, StandardCharsets.UTF_8.name());
            addressWithoutSchema = addressWithoutSchema + decodedQuery;
        }
        catch (UnsupportedEncodingException e) {
            throw new ServiceCombException("Failed to decode query.", (Throwable)e);
        }
        try {
            new URI("rest://" + addressWithoutSchema);
        }
        catch (URISyntaxException e) {
            throw new ServiceCombException("current service center not support encoded endpoint, please do not use chinese or space or anything need to be encoded.", (Throwable)e);
        }
        return addressWithoutSchema;
    }

    @Override
    public Object parseAddress(String address) {
        if (address == null) {
            return null;
        }
        return new URIEndpointObject(address);
    }
}

