/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.core.provider.producer;

import io.servicecomb.core.ProducerProvider;
import io.servicecomb.core.definition.MicroserviceMeta;
import io.servicecomb.core.definition.MicroserviceMetaManager;
import io.servicecomb.core.definition.SchemaMeta;
import io.servicecomb.core.definition.SchemaUtils;
import io.servicecomb.serviceregistry.RegistryUtils;
import io.servicecomb.serviceregistry.api.registry.Microservice;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProducerProviderManager {
    @Autowired(required=false)
    private List<ProducerProvider> producerProviderList = Collections.emptyList();
    @Inject
    private MicroserviceMetaManager microserviceMetaManager;

    public void init() throws Exception {
        for (ProducerProvider provider : this.producerProviderList) {
            provider.init();
        }
        Microservice microservice = RegistryUtils.getMicroservice();
        MicroserviceMeta microserviceMeta = this.microserviceMetaManager.getOrCreateMicroserviceMeta(microservice);
        for (SchemaMeta schemaMeta : microserviceMeta.getSchemaMetas()) {
            String content = SchemaUtils.swaggerToString(schemaMeta.getSwagger());
            microservice.addSchema(schemaMeta.getSchemaId(), content);
        }
    }
}

