/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.core.executor;

import com.netflix.config.DynamicPropertyFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedThreadExecutor
implements Executor {
    private static final Logger LOGGER = LoggerFactory.getLogger(FixedThreadExecutor.class);
    public static final String KEY_GROUP = "servicecomb.executor.default.group";
    public static final String KEY_THREAD = "servicecomb.executor.default.thread-per-group";
    private List<Executor> executorList = new ArrayList<Executor>();
    private AtomicInteger index = new AtomicInteger();
    private Map<Long, Executor> threadExectorMap = new ConcurrentHashMap<Long, Executor>();

    public FixedThreadExecutor() {
        int groupCount = DynamicPropertyFactory.getInstance().getIntProperty(KEY_GROUP, 2).get();
        int threadPerGroup = DynamicPropertyFactory.getInstance().getIntProperty(KEY_THREAD, Runtime.getRuntime().availableProcessors()).get();
        LOGGER.info("executor group {}, thread per group {}.", (Object)groupCount, (Object)threadPerGroup);
        for (int groupIdx = 0; groupIdx < groupCount; ++groupIdx) {
            this.executorList.add(Executors.newFixedThreadPool(threadPerGroup));
        }
    }

    @Override
    public void execute(Runnable command) {
        long threadId = Thread.currentThread().getId();
        Executor executor = this.threadExectorMap.computeIfAbsent(threadId, this::chooseExecutor);
        executor.execute(command);
    }

    private Executor chooseExecutor(long threadId) {
        int idx = this.index.getAndIncrement() % this.executorList.size();
        return this.executorList.get(idx);
    }
}

