/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.core.exception;

import io.servicecomb.core.exception.CseException;
import io.servicecomb.foundation.common.RegisterManager;
import io.servicecomb.foundation.common.utils.FortifyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionUtils.class);
    private static final String ERROR_DESC_MGR_MSG = "error desc mgr";
    protected static final RegisterManager<String, String> ERROR_DESC_MGR = new RegisterManager("error desc mgr");
    private static final String CSE_SCHEMA_OPERATION_ID_INVALID = "cse.schema.operation.id.invalid";
    private static final String CSE_HANDLER_REF_NOT_EXIST = "cse.handler.ref.not.exist";
    private static final String CSE_PRODUCER_OPERATION_NOT_EXIST = "cse.producer.operation.not.exist";
    private static final String CSE_LB_NO_AVAILABLE_ADDRESS = "cse.lb.no.available.address";

    protected ExceptionUtils() {
    }

    public static CseException createCseException(String code, Object ... args) {
        String msg = String.format((String)ERROR_DESC_MGR.ensureFindValue((Object)code), args);
        CseException exception = new CseException(code, msg);
        LOGGER.error(FortifyUtils.getErrorInfo((Throwable)exception));
        return exception;
    }

    public static CseException createCseException(String code, Throwable cause, Object ... args) {
        String msg = String.format((String)ERROR_DESC_MGR.ensureFindValue((Object)code), args);
        CseException exception = new CseException(code, msg, cause);
        LOGGER.error(FortifyUtils.getErrorInfo((Throwable)exception));
        return exception;
    }

    public static CseException producerOperationNotExist(String schemaId, String operationName) {
        return ExceptionUtils.createCseException(CSE_PRODUCER_OPERATION_NOT_EXIST, schemaId, operationName);
    }

    public static CseException operationIdInvalid(String schemaId, String path) {
        return ExceptionUtils.createCseException(CSE_SCHEMA_OPERATION_ID_INVALID, schemaId, path);
    }

    public static CseException handlerRefNotExist(String id) {
        return ExceptionUtils.createCseException(CSE_HANDLER_REF_NOT_EXIST, id);
    }

    public static CseException lbAddressNotFound(String microserviceName, String microserviceVersionRule, String transportName) {
        return ExceptionUtils.createCseException(CSE_LB_NO_AVAILABLE_ADDRESS, microserviceName, microserviceVersionRule, transportName);
    }

    static {
        ERROR_DESC_MGR.register((Object)CSE_HANDLER_REF_NOT_EXIST, (Object)"Handler not exist, id=%s");
        ERROR_DESC_MGR.register((Object)CSE_SCHEMA_OPERATION_ID_INVALID, (Object)"OperationId is invalid, schemaId=%s, path=%s");
        ERROR_DESC_MGR.register((Object)CSE_PRODUCER_OPERATION_NOT_EXIST, (Object)"Producer operation not exist, schemaId=%s, operationName=%s");
        ERROR_DESC_MGR.register((Object)CSE_LB_NO_AVAILABLE_ADDRESS, (Object)"No available address found. microserviceName=%s, version=%s, transportName=%s");
    }
}

