/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.core.definition.schema;

import io.servicecomb.core.definition.MicroserviceMeta;
import io.servicecomb.core.definition.MicroserviceMetaManager;
import io.servicecomb.core.definition.SchemaMeta;
import io.servicecomb.core.definition.SchemaUtils;
import io.servicecomb.core.definition.loader.SchemaLoader;
import io.servicecomb.core.definition.schema.SchemaContext;
import io.servicecomb.swagger.generator.core.CompositeSwaggerGeneratorContext;
import io.servicecomb.swagger.generator.core.SwaggerGenerator;
import io.servicecomb.swagger.generator.core.SwaggerGeneratorContext;
import io.servicecomb.swagger.generator.core.utils.ClassUtils;
import io.swagger.models.Swagger;
import java.net.URL;
import javax.inject.Inject;

public abstract class AbstractSchemaFactory<CONTEXT extends SchemaContext> {
    @Inject
    protected MicroserviceMetaManager microserviceMetaManager;
    @Inject
    protected SchemaLoader schemaLoader;
    @Inject
    protected CompositeSwaggerGeneratorContext compositeSwaggerGeneratorContext;

    public void setMicroserviceMetaManager(MicroserviceMetaManager microserviceMetaManager) {
        this.microserviceMetaManager = microserviceMetaManager;
    }

    protected SchemaMeta getOrCreateSchema(CONTEXT context) {
        MicroserviceMeta microserviceMeta = ((SchemaContext)context).getMicroserviceMeta();
        SchemaMeta schemaMeta = microserviceMeta.findSchemaMeta(((SchemaContext)context).getSchemaId());
        if (schemaMeta == null) {
            schemaMeta = this.createSchema(context);
        }
        ((SchemaContext)context).setSchemaMeta(schemaMeta);
        return schemaMeta;
    }

    protected abstract SchemaMeta createSchema(CONTEXT var1);

    protected Swagger loadSwagger(CONTEXT context) {
        return this.loadSwagger(((SchemaContext)context).getMicroserviceName(), ((SchemaContext)context).getSchemaId());
    }

    protected Swagger loadSwagger(String microserviceName, String schemaId) {
        String path = this.generateSchemaPath(microserviceName, schemaId);
        URL url = Thread.currentThread().getContextClassLoader().getResource(path);
        if (url == null) {
            return null;
        }
        return SchemaUtils.parseSwagger(url);
    }

    protected String generateSchemaPath(String microserviceName, String schemaId) {
        int idxAt = microserviceName.indexOf(":");
        if (idxAt < 0) {
            return String.format("microservices/%s/%s.yaml", microserviceName, schemaId);
        }
        String appId = microserviceName.substring(0, idxAt);
        String realMicroserviceName = microserviceName.substring(idxAt + 1);
        return String.format("applications/%s/%s/%s.yaml", appId, realMicroserviceName, schemaId);
    }

    protected SwaggerGenerator generateSwagger(CONTEXT context) {
        SwaggerGeneratorContext generatorContext = this.compositeSwaggerGeneratorContext.selectContext(((SchemaContext)context).getProviderClass());
        SwaggerGenerator generator = new SwaggerGenerator(generatorContext, ((SchemaContext)context).getProviderClass());
        generator.setClassLoader(((SchemaContext)context).getMicroserviceMeta().getClassLoader());
        generator.setPackageName(SchemaUtils.generatePackageName(((SchemaContext)context).getMicroserviceMeta(), ((SchemaContext)context).getSchemaId()));
        generator.generate();
        ClassUtils.getOrCreateInterface((SwaggerGenerator)generator);
        return generator;
    }
}

