/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.core.definition.classloader;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicroserviceClassLoader
extends ClassLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroserviceClassLoader.class);
    private String microserviceName;
    private String version;

    public MicroserviceClassLoader(String microserviceName, String version) {
        super(Thread.currentThread().getContextClassLoader());
        this.microserviceName = microserviceName;
        this.version = version;
        LOGGER.info("create classloader for microservice {}:{}.", (Object)microserviceName, (Object)version);
    }

    public String getMicroserviceName() {
        return this.microserviceName;
    }

    public String getVersion() {
        return this.version;
    }

    protected void finalize() throws Throwable {
        LOGGER.info("gc: classloader of microservice {}:{}.", (Object)this.microserviceName, (Object)this.version);
        super.finalize();
    }
}

