/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.core.definition;

import io.servicecomb.core.definition.SchemaMeta;
import io.servicecomb.core.executor.ExecutorManager;
import io.servicecomb.swagger.invocation.AsyncResponse;
import io.servicecomb.swagger.invocation.response.ResponseMeta;
import io.servicecomb.swagger.invocation.response.ResponsesMeta;
import io.swagger.models.Operation;
import io.swagger.models.parameters.Parameter;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;

public class OperationMeta {
    private SchemaMeta schemaMeta;
    private String schemaQualifiedName;
    private String microserviceQualifiedName;
    private Method method;
    private boolean sync;
    private String httpMethod;
    private String operationPath;
    private Operation swaggerOperation;
    private Executor executor;
    private ResponsesMeta responsesMeta = new ResponsesMeta();
    private Map<String, Object> extData = new ConcurrentHashMap<String, Object>();

    public void init(SchemaMeta schemaMeta, Method method, String operationPath, String httpMethod, Operation swaggerOperation) {
        this.schemaMeta = schemaMeta;
        this.schemaQualifiedName = schemaMeta.getSchemaId() + "." + method.getName();
        this.microserviceQualifiedName = schemaMeta.getMicroserviceName() + "." + this.schemaQualifiedName;
        this.operationPath = operationPath;
        this.method = method;
        this.httpMethod = httpMethod.toUpperCase(Locale.US);
        this.swaggerOperation = swaggerOperation;
        this.executor = ExecutorManager.findExecutor(this);
        this.collectMethodType();
        this.responsesMeta.init(schemaMeta.getMicroserviceMeta().getClassLoader(), schemaMeta.getPackageName(), schemaMeta.getSwagger(), swaggerOperation, method.getGenericReturnType());
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getOperationPath() {
        return this.operationPath;
    }

    private void collectMethodType() {
        Class<?>[] params = this.method.getParameterTypes();
        if (params.length == 0) {
            this.sync = true;
            return;
        }
        Class<?> lastParam = params[params.length - 1];
        this.sync = !AsyncResponse.class.isAssignableFrom(lastParam);
    }

    public Operation getSwaggerOperation() {
        return this.swaggerOperation;
    }

    public ResponseMeta findResponseMeta(int statusCode) {
        return this.responsesMeta.findResponseMeta(statusCode);
    }

    public SchemaMeta getSchemaMeta() {
        return this.schemaMeta;
    }

    public String getSchemaQualifiedName() {
        return this.schemaQualifiedName;
    }

    public String getMicroserviceQualifiedName() {
        return this.microserviceQualifiedName;
    }

    public String getMicroserviceName() {
        return this.schemaMeta.getMicroserviceName();
    }

    public Method getMethod() {
        return this.method;
    }

    public String getOperationId() {
        return this.swaggerOperation.getOperationId();
    }

    public String getParamName(int idx) {
        return ((Parameter)this.swaggerOperation.getParameters().get(idx)).getName();
    }

    public void putExtData(String key, Object data) {
        this.extData.put(key, data);
    }

    public <T> T getExtData(String key) {
        return (T)this.extData.get(key);
    }

    public boolean isSync() {
        return this.sync;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public int getParamSize() {
        return this.swaggerOperation.getParameters().size();
    }
}

