/*
 * Copyright 2017 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.servicecomb.core.handler;

import io.servicecomb.core.Handler;
import io.servicecomb.core.handler.impl.TransportClientHandler;

public class ConsumerHandlerManager extends AbstractHandlerManager {
  public static final ConsumerHandlerManager INSTANCE = new ConsumerHandlerManager();

  @Override
  protected String getName() {
    return "Consumer";
  }

  @Override
  protected String getInnerDefaultChainDef() {
    return "simpleLB";
  }

  @Override
  protected Handler getLastHandler() {
    return TransportClientHandler.INSTANCE;
  }
}
