/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.core.transport;

import com.netflix.config.DynamicPropertyFactory;
import io.servicecomb.core.Endpoint;
import io.servicecomb.core.Transport;
import io.servicecomb.foundation.common.net.NetUtils;
import io.servicecomb.foundation.common.net.URIEndpointObject;
import io.servicecomb.foundation.vertx.VertxUtils;
import io.servicecomb.serviceregistry.RegistryUtils;
import io.vertx.core.Vertx;
import java.util.Map;

public abstract class AbstractTransport
implements Transport {
    public static final String ENDPOINT_KEY = "cse.endpoint";
    private static final long DEFAULT_TIMEOUT_MILLIS = 30000L;
    private static Long msReqeustTimeout = null;
    protected Vertx transportVertx = VertxUtils.getOrCreateVertxByName((String)"transport", null);
    protected Endpoint endpoint;
    protected Endpoint publishEndpoint;

    public static long getRequestTimeout() {
        if (msReqeustTimeout != null) {
            return msReqeustTimeout;
        }
        long msTimeout = DynamicPropertyFactory.getInstance().getLongProperty("cse.request.timeout", 30000L).get();
        if (msTimeout <= 0L) {
            msTimeout = 30000L;
        }
        msReqeustTimeout = msTimeout;
        return msReqeustTimeout;
    }

    @Override
    public Endpoint getPublishEndpoint() {
        return this.publishEndpoint;
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    protected void setListenAddressWithoutSchema(String addressWithoutSchema) {
        this.setListenAddressWithoutSchema(addressWithoutSchema, null);
    }

    protected void setListenAddressWithoutSchema(String addressWithoutSchema, Map<String, String> pairs) {
        if (addressWithoutSchema != null && pairs != null && !pairs.isEmpty()) {
            int idx = addressWithoutSchema.indexOf(63);
            addressWithoutSchema = idx == -1 ? addressWithoutSchema + "?" : addressWithoutSchema + "&";
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : pairs.entrySet()) {
                sb.append(entry.getKey()).append('=').append(entry.getValue()).append('&');
            }
            sb.setLength(sb.length() - 1);
            addressWithoutSchema = addressWithoutSchema + sb.toString();
        }
        this.endpoint = new Endpoint(this, NetUtils.getRealListenAddress((String)this.getName(), (String)addressWithoutSchema));
        this.publishEndpoint = this.endpoint.getEndpoint() != null ? new Endpoint(this, RegistryUtils.getPublishAddress((String)this.getName(), (String)addressWithoutSchema)) : null;
    }

    @Override
    public Object parseAddress(String address) {
        if (address == null) {
            return null;
        }
        return new URIEndpointObject(address);
    }
}

