/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.core.provider.consumer;

import io.servicecomb.core.Invocation;
import io.servicecomb.core.definition.SchemaMeta;
import io.servicecomb.core.invocation.InvocationFactory;
import io.servicecomb.core.provider.consumer.ReactiveResponseExecutor;
import io.servicecomb.core.provider.consumer.ReferenceConfig;
import io.servicecomb.core.provider.consumer.ReferenceConfigUtils;
import io.servicecomb.core.provider.consumer.SyncResponseExecutor;
import io.servicecomb.swagger.invocation.AsyncResponse;
import io.servicecomb.swagger.invocation.Response;
import io.servicecomb.swagger.invocation.exception.ExceptionFactory;
import io.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InvokerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(InvokerUtils.class);

    private InvokerUtils() {
    }

    public static Object syncInvoke(String microserviceName, String schemaId, String operationName, Object[] args) {
        ReferenceConfig referenceConfig = ReferenceConfigUtils.getForInvoke(microserviceName);
        SchemaMeta schemaMeta = referenceConfig.getMicroserviceMeta().ensureFindSchemaMeta(schemaId);
        Invocation invocation = InvocationFactory.forConsumer(referenceConfig, schemaMeta, operationName, args);
        return InvokerUtils.syncInvoke(invocation);
    }

    public static Object syncInvoke(String microserviceName, String microserviceVersion, String transport, String schemaId, String operationName, Object[] args) {
        ReferenceConfig referenceConfig = ReferenceConfigUtils.getForInvoke(microserviceName, microserviceVersion, transport);
        SchemaMeta schemaMeta = referenceConfig.getMicroserviceMeta().ensureFindSchemaMeta(schemaId);
        Invocation invocation = InvocationFactory.forConsumer(referenceConfig, schemaMeta, operationName, args);
        return InvokerUtils.syncInvoke(invocation);
    }

    public static Object syncInvoke(Invocation invocation) throws InvocationException {
        Response response = InvokerUtils.innerSyncInvoke(invocation);
        if (response.isSuccessed()) {
            return response.getResult();
        }
        throw ExceptionFactory.convertConsumerException((Throwable)((Throwable)response.getResult()));
    }

    public static Response innerSyncInvoke(Invocation invocation) {
        try {
            SyncResponseExecutor respExecutor = new SyncResponseExecutor();
            invocation.setResponseExecutor(respExecutor);
            invocation.next(resp -> respExecutor.setResponse(resp));
            return respExecutor.waitResponse();
        }
        catch (Throwable e) {
            String msg = String.format("invoke failed, %s", invocation.getOperationMeta().getMicroserviceQualifiedName());
            LOGGER.debug(msg, e);
            return Response.createConsumerFail((Throwable)e);
        }
    }

    public static void reactiveInvoke(Invocation invocation, AsyncResponse asyncResp) {
        try {
            ReactiveResponseExecutor respExecutor = new ReactiveResponseExecutor();
            invocation.setResponseExecutor(respExecutor);
            invocation.next(asyncResp);
        }
        catch (Throwable e) {
            LOGGER.error("invoke failed, {}", (Object)invocation.getOperationMeta().getMicroserviceQualifiedName());
            asyncResp.consumerFail(e);
        }
    }

    public static Object invoke(Invocation invocation) {
        if (invocation.getOperationMeta().isSync()) {
            return InvokerUtils.syncInvoke(invocation);
        }
        Object[] args = invocation.getArgs();
        AsyncResponse asyncResp = (AsyncResponse)args[args.length - 1];
        InvokerUtils.reactiveInvoke(invocation, asyncResp);
        return null;
    }
}

