/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.core.provider;

import java.lang.reflect.Field;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Component
public class CseBeanPostProcessor
implements ApplicationContextAware,
BeanPostProcessor {
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    private List<ProviderProcessor> providerProcessorList;
    @Autowired(required=false)
    private List<ConsumerFieldProcessor> consumerProcessorList;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Object postProcessBeforeInitialization(final Object bean, String beanName) throws BeansException {
        if (this.consumerProcessorList == null || this.consumerProcessorList.isEmpty()) {
            return bean;
        }
        ReflectionUtils.doWithFields(bean.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                for (ConsumerFieldProcessor processor : CseBeanPostProcessor.this.consumerProcessorList) {
                    processor.processConsumerField(CseBeanPostProcessor.this.applicationContext, bean, field);
                }
            }
        });
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (this.providerProcessorList != null && !this.providerProcessorList.isEmpty()) {
            for (ProviderProcessor processor : this.providerProcessorList) {
                processor.processProvider(this.applicationContext, beanName, bean);
            }
        }
        return bean;
    }

    public static interface ConsumerFieldProcessor
    extends EmptyBeanPostProcessor {
        public <CONSUMER_ANNOTATION> void processConsumerField(ApplicationContext var1, Object var2, Field var3);
    }

    public static interface ProviderProcessor
    extends EmptyBeanPostProcessor {
        public void processProvider(ApplicationContext var1, String var2, Object var3);
    }

    public static interface EmptyBeanPostProcessor
    extends BeanPostProcessor {
        default public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }

        default public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }
    }
}

