/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.core.handler.impl;

import io.servicecomb.core.Endpoint;
import io.servicecomb.core.Invocation;
import io.servicecomb.core.endpoint.EndpointsCache;
import io.servicecomb.core.exception.ExceptionUtils;
import io.servicecomb.core.handler.impl.AbstractHandler;
import io.servicecomb.swagger.invocation.AsyncResponse;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class SimpleLoadBalanceHandler
extends AbstractHandler {
    private AtomicInteger index = new AtomicInteger();
    private volatile Map<String, EndpointsCache> endpointsCacheMap = new ConcurrentHashMap<String, EndpointsCache>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(Invocation invocation, AsyncResponse asyncResp) throws Exception {
        List endpoints;
        String transportName = invocation.getConfigTransportName();
        EndpointsCache endpointsCache = this.endpointsCacheMap.get(transportName);
        if (endpointsCache == null) {
            SimpleLoadBalanceHandler simpleLoadBalanceHandler = this;
            synchronized (simpleLoadBalanceHandler) {
                endpointsCache = this.endpointsCacheMap.get(invocation.getConfigTransportName());
                if (endpointsCache == null) {
                    endpointsCache = new EndpointsCache(invocation.getAppId(), invocation.getMicroserviceName(), invocation.getMicroserviceVersionRule(), transportName);
                    this.endpointsCacheMap.put(transportName, endpointsCache);
                }
            }
        }
        if ((endpoints = endpointsCache.getLatestEndpoints()) == null || endpoints.isEmpty()) {
            asyncResp.consumerFail((Throwable)ExceptionUtils.lbAddressNotFound(invocation.getMicroserviceName(), invocation.getMicroserviceVersionRule(), transportName));
            return;
        }
        int idx = Math.abs(this.index.getAndIncrement());
        Endpoint endpoint = (Endpoint)endpoints.get(idx %= endpoints.size());
        invocation.setEndpoint(endpoint);
        invocation.next(asyncResp);
    }
}

