/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.core.definition.schema;

import io.servicecomb.core.definition.MicroserviceMeta;
import io.servicecomb.core.definition.SchemaMeta;
import io.servicecomb.core.definition.SchemaUtils;
import io.servicecomb.core.definition.loader.SchemaListenerManager;
import io.servicecomb.core.definition.schema.AbstractSchemaFactory;
import io.servicecomb.core.definition.schema.ConsumerSchemaContext;
import io.servicecomb.serviceregistry.RegistryUtils;
import io.servicecomb.serviceregistry.api.registry.Microservice;
import io.servicecomb.serviceregistry.client.ServiceRegistryClient;
import io.swagger.models.Swagger;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class ConsumerSchemaFactory
extends AbstractSchemaFactory<ConsumerSchemaContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerSchemaFactory.class);
    @Inject
    protected SchemaListenerManager schemaListenerManager;
    private final Object lock = new Object();

    public void setSchemaListenerManager(SchemaListenerManager schemaListenerManager) {
        this.schemaListenerManager = schemaListenerManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MicroserviceMeta getOrCreateMicroserviceMeta(String microserviceName, String microserviceVersionRule) {
        MicroserviceMeta microserviceMeta = (MicroserviceMeta)this.microserviceMetaManager.findValue(microserviceName);
        if (microserviceMeta != null) {
            return microserviceMeta;
        }
        Object object = this.lock;
        synchronized (object) {
            microserviceMeta = (MicroserviceMeta)this.microserviceMetaManager.findValue(microserviceName);
            if (microserviceMeta != null) {
                return microserviceMeta;
            }
            microserviceMeta = new MicroserviceMeta(microserviceName);
            Microservice microservice = this.findMicroservice(microserviceMeta, microserviceVersionRule);
            if (microservice == null) {
                throw new Error(String.format("can not get microservice from service center, name=%s", microserviceName));
            }
            this.getOrCreateConsumerSchema(microserviceMeta, microservice);
            this.microserviceMetaManager.register(microserviceName, microserviceMeta);
            this.schemaListenerManager.notifySchemaListener(microserviceMeta);
            return microserviceMeta;
        }
    }

    protected Microservice findMicroservice(MicroserviceMeta microserviceMeta, String microserviceVersionRule) {
        String appId = microserviceMeta.getAppId();
        String microserviceName = microserviceMeta.getName();
        ServiceRegistryClient client = RegistryUtils.getServiceRegistryClient();
        String microserviceId = client.getMicroserviceId(appId, microserviceMeta.getShortName(), microserviceVersionRule);
        if (StringUtils.isEmpty((Object)microserviceId)) {
            LOGGER.error("can not get microservice id, {}:{}:{}", new Object[]{appId, microserviceName, microserviceVersionRule});
            return null;
        }
        Microservice microservice = client.getMicroservice(microserviceId);
        if (microservice == null) {
            LOGGER.error("can not get microservice, {}:{}:{}", new Object[]{appId, microserviceName, microserviceVersionRule});
            return null;
        }
        LOGGER.info("Found schema ids from service center, {}:{}:{}:{}", new Object[]{appId, microserviceName, microserviceVersionRule, microservice.getSchemas()});
        return microservice;
    }

    protected void getOrCreateConsumerSchema(MicroserviceMeta microserviceMeta, Microservice microservice) {
        for (String schemaId : microservice.getSchemas()) {
            ConsumerSchemaContext context = new ConsumerSchemaContext();
            context.setMicroserviceMeta(microserviceMeta);
            context.setMicroservice(microservice);
            context.setSchemaId(schemaId);
            context.setProviderClass(null);
            this.getOrCreateSchema(context);
        }
    }

    @Override
    protected SchemaMeta createSchema(ConsumerSchemaContext context) {
        Swagger swagger = this.loadSwagger(context);
        return this.schemaLoader.registerSchema(context.getMicroserviceMeta(), context.getSchemaId(), swagger);
    }

    @Override
    protected Swagger loadSwagger(ConsumerSchemaContext context) {
        Swagger swagger = super.loadSwagger(context);
        if (swagger != null) {
            return swagger;
        }
        ServiceRegistryClient client = RegistryUtils.getServiceRegistryClient();
        String schemaContent = client.getSchema(context.getMicroservice().getServiceId(), context.getSchemaId());
        LOGGER.info("load schema from service center, microservice={}:{}:{}, schemaId={}, result={}", new Object[]{context.getMicroservice().getAppId(), context.getMicroservice().getServiceName(), context.getMicroservice().getVersion(), context.getSchemaId(), !StringUtils.isEmpty((Object)schemaContent)});
        if (schemaContent != null) {
            return SchemaUtils.parseSwagger(schemaContent);
        }
        throw new Error(String.format("no schema in local, and can not get schema from service center, %s:%s", context.getMicroserviceName(), context.getSchemaId()));
    }
}

