/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.core.definition;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.servicecomb.core.definition.MicroserviceMeta;
import io.servicecomb.swagger.generator.core.utils.ClassUtils;
import io.swagger.models.Swagger;
import io.swagger.util.Yaml;
import java.net.URL;
import org.apache.commons.io.IOUtils;

public final class SchemaUtils {
    private SchemaUtils() {
    }

    public static String generatePackageName(MicroserviceMeta microserviceMeta, String schemaId) {
        String name = "cse.gen." + microserviceMeta.getAppId() + "." + microserviceMeta.getShortName() + "." + schemaId;
        return ClassUtils.correctClassName((String)name);
    }

    public static String swaggerToString(Swagger swagger) {
        try {
            return Yaml.mapper().writeValueAsString((Object)swagger);
        }
        catch (JsonProcessingException e) {
            throw new Error(e);
        }
    }

    public static Swagger parseSwagger(URL url) {
        try {
            String swaggerContext = IOUtils.toString((URL)url);
            return (Swagger)Yaml.mapper().readValue(swaggerContext, Swagger.class);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
    }

    public static Swagger parseSwagger(String swaggerContent) {
        try {
            return (Swagger)Yaml.mapper().readValue(swaggerContent, Swagger.class);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
    }
}

