/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.core;

import io.servicecomb.core.Endpoint;
import io.servicecomb.core.Handler;
import io.servicecomb.core.Transport;
import io.servicecomb.core.definition.OperationMeta;
import io.servicecomb.core.definition.SchemaMeta;
import io.servicecomb.core.provider.consumer.ReferenceConfig;
import io.servicecomb.swagger.invocation.AsyncResponse;
import io.servicecomb.swagger.invocation.InvocationType;
import io.servicecomb.swagger.invocation.SwaggerInvocation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class Invocation
extends SwaggerInvocation {
    private ReferenceConfig referenceConfig;
    private SchemaMeta schemaMeta;
    private OperationMeta operationMeta;
    private Endpoint endpoint;
    private Map<String, Object> handlerContext = new HashMap<String, Object>();
    private List<Handler> handlerList;
    private int handlerIndex;
    private Executor responseExecutor;

    public Invocation(ReferenceConfig referenceConfig, OperationMeta operationMeta, Object[] swaggerArguments) {
        this.invocationType = InvocationType.CONSUMER;
        this.referenceConfig = referenceConfig;
        this.init(operationMeta, swaggerArguments);
    }

    public Invocation(Endpoint endpoint, OperationMeta operationMeta, Object[] swaggerArguments) {
        this.invocationType = InvocationType.PRODUCER;
        this.endpoint = endpoint;
        this.init(operationMeta, swaggerArguments);
    }

    private void init(OperationMeta operationMeta, Object[] swaggerArguments) {
        this.schemaMeta = operationMeta.getSchemaMeta();
        this.operationMeta = operationMeta;
        this.swaggerArguments = swaggerArguments;
        this.handlerList = this.getHandlerChain();
        this.handlerIndex = 0;
    }

    public Transport getTransport() {
        return this.endpoint.getTransport();
    }

    public List<Handler> getHandlerChain() {
        return InvocationType.CONSUMER.equals((Object)this.invocationType) ? this.schemaMeta.getConsumerHandlerChain() : this.schemaMeta.getProviderHandlerChain();
    }

    public Executor getResponseExecutor() {
        return this.responseExecutor;
    }

    public void setResponseExecutor(Executor responseExecutor) {
        this.responseExecutor = responseExecutor;
    }

    public SchemaMeta getSchemaMeta() {
        return this.schemaMeta;
    }

    public OperationMeta getOperationMeta() {
        return this.operationMeta;
    }

    public Object[] getArgs() {
        return this.swaggerArguments;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Map<String, Object> getHandlerContext() {
        return this.handlerContext;
    }

    public int getHandlerIndex() {
        return this.handlerIndex;
    }

    public void setHandlerIndex(int handlerIndex) {
        this.handlerIndex = handlerIndex;
    }

    public void next(AsyncResponse asyncResp) throws Exception {
        int runIndex = this.handlerIndex++;
        this.handlerList.get(runIndex).handle(this, asyncResp);
    }

    public String getSchemaId() {
        return this.schemaMeta.getSchemaId();
    }

    public String getOperationName() {
        return this.operationMeta.getOperationId();
    }

    public String getConfigTransportName() {
        return this.referenceConfig.getTransport();
    }

    public String getRealTransportName() {
        return this.endpoint != null ? this.endpoint.getTransport().getName() : this.getConfigTransportName();
    }

    public String getMicroserviceName() {
        return this.schemaMeta.getMicroserviceName();
    }

    public String getAppId() {
        return this.schemaMeta.getMicroserviceMeta().getAppId();
    }

    public String getMicroserviceVersionRule() {
        return this.referenceConfig.getMicroserviceVersionRule();
    }

    public String getInvocationQualifiedName() {
        return this.invocationType.name() + " " + this.getRealTransportName() + " " + this.getOperationMeta().getMicroserviceQualifiedName();
    }

    public String getMicroserviceQualifiedName() {
        return this.operationMeta.getMicroserviceQualifiedName();
    }
}

