/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.core;

import io.servicecomb.core.BootListener;
import io.servicecomb.core.definition.loader.SchemaListenerManager;
import io.servicecomb.core.endpoint.AbstractEndpointsCache;
import io.servicecomb.core.handler.HandlerConfigUtils;
import io.servicecomb.core.provider.consumer.ConsumerProviderManager;
import io.servicecomb.core.provider.consumer.ReferenceConfigUtils;
import io.servicecomb.core.provider.producer.ProducerProviderManager;
import io.servicecomb.core.transport.TransportManager;
import io.servicecomb.foundation.common.utils.BeanUtils;
import io.servicecomb.foundation.common.utils.FortifyUtils;
import io.servicecomb.serviceregistry.RegistryUtils;
import java.util.Collection;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.Ordered;

public class CseApplicationListener
implements ApplicationListener<ApplicationEvent>,
Ordered,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(CseApplicationListener.class);
    private static boolean isInit = false;
    @Inject
    private ProducerProviderManager producerProviderManager;
    @Inject
    private ConsumerProviderManager consumerProviderManager;
    @Inject
    private TransportManager transportManager;
    @Inject
    private SchemaListenerManager schemaListenerManager;
    private Collection<BootListener> bootListenerList;
    private Class<?> initEventClass = ContextRefreshedEvent.class;
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        BeanUtils.setContext((ApplicationContext)applicationContext);
        RegistryUtils.init();
    }

    public void setInitEventClass(Class<?> initEventClass) {
        this.initEventClass = initEventClass;
    }

    public int getOrder() {
        return -1000;
    }

    protected void triggerEvent(BootListener.EventType eventType) {
        BootListener.BootEvent event = new BootListener.BootEvent();
        event.setEventType(eventType);
        for (BootListener listener : this.bootListenerList) {
            listener.onBootEvent(event);
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (this.initEventClass.isInstance(event)) {
            if (!isInit) {
                try {
                    this.bootListenerList = this.applicationContext.getBeansOfType(BootListener.class).values();
                    AbstractEndpointsCache.init(RegistryUtils.getInstanceCacheManager(), this.transportManager);
                    this.triggerEvent(BootListener.EventType.BEFORE_HANDLER);
                    HandlerConfigUtils.init();
                    this.triggerEvent(BootListener.EventType.AFTER_HANDLER);
                    this.triggerEvent(BootListener.EventType.BEFORE_PRODUCER_PROVIDER);
                    this.producerProviderManager.init();
                    this.triggerEvent(BootListener.EventType.AFTER_PRODUCER_PROVIDER);
                    this.triggerEvent(BootListener.EventType.BEFORE_CONSUMER_PROVIDER);
                    this.consumerProviderManager.init();
                    this.triggerEvent(BootListener.EventType.AFTER_CONSUMER_PROVIDER);
                    this.triggerEvent(BootListener.EventType.BEFORE_TRANSPORT);
                    this.transportManager.init();
                    this.triggerEvent(BootListener.EventType.AFTER_TRANSPORT);
                    this.schemaListenerManager.notifySchemaListener();
                    this.triggerEvent(BootListener.EventType.BEFORE_REGISTRY);
                    RegistryUtils.run();
                    ReferenceConfigUtils.setReady(true);
                    this.triggerEvent(BootListener.EventType.AFTER_REGISTRY);
                    if (this.applicationContext instanceof AbstractApplicationContext) {
                        ((AbstractApplicationContext)this.applicationContext).registerShutdownHook();
                    }
                    isInit = true;
                }
                catch (Exception e) {
                    LOGGER.error("cse init failed, {}", (Object)FortifyUtils.getErrorInfo((Throwable)e));
                }
            }
        } else if (event instanceof ContextClosedEvent) {
            LOGGER.warn("cse is closing now...");
            RegistryUtils.destory();
            isInit = false;
        }
    }
}

