/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.core.executor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;

public class FixedThreadExecutor
implements Executor {
    private List<Executor> executorList = new ArrayList<Executor>();
    private AtomicInteger index = new AtomicInteger();
    private Map<Long, Executor> threadExectorMap = new ConcurrentHashMap<Long, Executor>();

    public FixedThreadExecutor() {
        this.executorList.add(Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()));
        this.executorList.add(Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()));
    }

    @Override
    public void execute(Runnable command) {
        long threadId = Thread.currentThread().getId();
        Executor executor = this.threadExectorMap.get(threadId);
        if (executor == null) {
            int idx = this.index.getAndIncrement() % this.executorList.size();
            executor = this.executorList.get(idx);
            this.threadExectorMap.put(threadId, executor);
        }
        executor.execute(command);
    }
}

