/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.core.definition;

import io.servicecomb.core.Handler;
import io.servicecomb.core.definition.CommonService;
import io.servicecomb.core.definition.MicroserviceMeta;
import io.servicecomb.core.definition.OperationMeta;
import io.servicecomb.core.definition.SchemaUtils;
import io.servicecomb.core.exception.ExceptionUtils;
import io.servicecomb.foundation.common.utils.ReflectUtils;
import io.servicecomb.swagger.generator.core.utils.ClassUtils;
import io.swagger.models.HttpMethod;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

public class SchemaMeta
extends CommonService<OperationMeta> {
    private String packageName;
    private Swagger swagger;
    private MicroserviceMeta microserviceMeta;
    private String microserviceQualifiedName;
    private Class<?> swaggerIntf;
    private List<Handler> consumerHandlerChain;
    private List<Handler> providerHandlerChain;

    public SchemaMeta(Swagger swagger, MicroserviceMeta microserviceMeta, String schemaId) {
        this.packageName = SchemaUtils.generatePackageName(microserviceMeta, schemaId);
        this.swagger = swagger;
        this.name = schemaId;
        this.microserviceMeta = microserviceMeta;
        this.microserviceQualifiedName = microserviceMeta.getName() + "." + schemaId;
        this.swaggerIntf = ClassUtils.getOrCreateInterface((Swagger)swagger, (ClassLoader)microserviceMeta.getClassLoader(), (String)this.packageName);
        this.createOperationMgr("schemaMeta " + schemaId + " operation mgr");
        this.operationMgr.setRegisterErrorFmt("Operation name repeat, schema=%s, operation=%s");
        this.initOperations();
    }

    public String getPackageName() {
        return this.packageName;
    }

    private void initOperations() {
        for (Map.Entry entry : this.swagger.getPaths().entrySet()) {
            String strPath = (String)entry.getKey();
            Path path = (Path)entry.getValue();
            for (Map.Entry operationEntry : path.getOperationMap().entrySet()) {
                Operation operation = (Operation)operationEntry.getValue();
                if (operation.getOperationId() == null) {
                    throw ExceptionUtils.operationIdInvalid(this.getSchemaId(), strPath);
                }
                Method method = ReflectUtils.findMethod(this.swaggerIntf, (String)operation.getOperationId());
                if (method == null) {
                    throw ExceptionUtils.operationNotExist(this.getSchemaId(), operation.getOperationId());
                }
                String httpMethod = ((HttpMethod)operationEntry.getKey()).name();
                OperationMeta operationMeta = new OperationMeta();
                operationMeta.init(this, method, strPath, httpMethod, operation);
                this.operationMgr.register((Object)method.getName(), (Object)operationMeta);
            }
        }
    }

    public Swagger getSwagger() {
        return this.swagger;
    }

    public String getSchemaId() {
        return this.name;
    }

    public String getMicroserviceQualifiedName() {
        return this.microserviceQualifiedName;
    }

    public String getMicroserviceName() {
        return this.microserviceMeta.getName();
    }

    public MicroserviceMeta getMicroserviceMeta() {
        return this.microserviceMeta;
    }

    public Class<?> getSwaggerIntf() {
        return this.swaggerIntf;
    }

    public List<Handler> getConsumerHandlerChain() {
        return this.consumerHandlerChain;
    }

    public void setConsumerHandlerChain(List<Handler> consumerHandlerChain) {
        this.consumerHandlerChain = consumerHandlerChain;
    }

    public List<Handler> getProviderHandlerChain() {
        return this.providerHandlerChain;
    }

    public void setProviderHandlerChain(List<Handler> providerHandlerChain) {
        this.providerHandlerChain = providerHandlerChain;
    }
}

