/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.core.definition;

import io.servicecomb.core.definition.MicroserviceMeta;
import io.servicecomb.core.definition.SchemaMeta;
import io.servicecomb.foundation.common.RegisterManager;
import io.servicecomb.serviceregistry.api.registry.Microservice;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class MicroserviceMetaManager
extends RegisterManager<String, MicroserviceMeta> {
    private static final String MICROSERVICE_SCHEMA_MGR = "microservice meta manager";
    private final Object lock = new Object();

    public MicroserviceMetaManager() {
        super(MICROSERVICE_SCHEMA_MGR);
    }

    public SchemaMeta ensureFindSchemaMeta(String microserviceName, String schemaId) {
        MicroserviceMeta microserviceMeta = (MicroserviceMeta)this.ensureFindValue(microserviceName);
        return microserviceMeta.ensureFindSchemaMeta(schemaId);
    }

    public Collection<SchemaMeta> getAllSchemaMeta(String microserviceName) {
        MicroserviceMeta microserviceMeta = (MicroserviceMeta)this.ensureFindValue(microserviceName);
        return microserviceMeta.getSchemaMetas();
    }

    public MicroserviceMeta getOrCreateMicroserviceMeta(Microservice microservice) {
        String microserviceName = microservice.getServiceName();
        MicroserviceMeta microserviceMeta = this.getOrCreateMicroserviceMeta(microserviceName);
        if (!StringUtils.isEmpty((CharSequence)microservice.getAlias()) && this.findValue(microservice.getAlias()) == null) {
            this.register(microservice.getAlias(), microserviceMeta);
        }
        return microserviceMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MicroserviceMeta getOrCreateMicroserviceMeta(String microserviceName) {
        MicroserviceMeta microserviceMeta = (MicroserviceMeta)this.findValue(microserviceName);
        if (microserviceMeta == null) {
            Object object = this.lock;
            synchronized (object) {
                microserviceMeta = (MicroserviceMeta)this.findValue(microserviceName);
                if (microserviceMeta == null) {
                    microserviceMeta = new MicroserviceMeta(microserviceName);
                    this.register(microserviceName, microserviceMeta);
                }
            }
        }
        return microserviceMeta;
    }
}

