/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.core.unittest;

import io.servicecomb.core.Handler;
import io.servicecomb.core.definition.MicroserviceMeta;
import io.servicecomb.core.definition.MicroserviceMetaManager;
import io.servicecomb.core.definition.SchemaMeta;
import io.servicecomb.core.definition.loader.SchemaLoader;
import io.servicecomb.core.handler.ConsumerHandlerManager;
import io.servicecomb.core.handler.ProducerHandlerManager;
import io.servicecomb.core.handler.config.Config;
import io.servicecomb.core.handler.impl.SimpleLoadBalanceHandler;
import io.servicecomb.foundation.common.utils.BeanUtils;
import io.servicecomb.serviceregistry.RegistryUtils;
import io.servicecomb.serviceregistry.api.registry.Microservice;
import io.servicecomb.swagger.generator.core.unittest.UnitTestSwaggerUtils;
import io.swagger.models.Swagger;
import java.util.Collections;
import java.util.List;
import mockit.Mock;
import mockit.MockUp;
import org.mockito.Mockito;
import org.springframework.context.ApplicationContext;

public class UnitTestMeta {
    private static boolean inited = false;
    private MicroserviceMetaManager microserviceMetaManager = new MicroserviceMetaManager();
    private SchemaLoader schemaLoader = new SchemaLoader(){

        @Override
        public void putSelfBasePathIfAbsent(String microserviceName, String basePath) {
        }
    };
    private Microservice microservice = new Microservice();

    public static synchronized void init() {
        if (inited) {
            return;
        }
        Config config = new Config();
        Class<SimpleLoadBalanceHandler> cls = SimpleLoadBalanceHandler.class;
        config.getHandlerClassMap().put("simpleLB", cls);
        ProducerHandlerManager.INSTANCE.init(config);
        ConsumerHandlerManager.INSTANCE.init(config);
        ApplicationContext applicationContext = (ApplicationContext)Mockito.mock(ApplicationContext.class);
        BeanUtils.setContext((ApplicationContext)applicationContext);
        inited = true;
    }

    public UnitTestMeta() {
        this.microservice.setAppId("app");
        this.microservice.setServiceName("testname");
        new MockUp<RegistryUtils>(){

            @Mock
            private Microservice createMicroserviceFromDefinition() {
                return UnitTestMeta.this.microservice;
            }
        };
        new MockUp<ConsumerHandlerManager>(){

            @Mock
            public List<Handler> getOrCreate(String name) {
                return Collections.emptyList();
            }
        };
        new MockUp<ProducerHandlerManager>(){

            @Mock
            public List<Handler> getOrCreate(String name) {
                return Collections.emptyList();
            }
        };
        this.schemaLoader.setMicroserviceMetaManager(this.microserviceMetaManager);
    }

    public void setMicroservice(Microservice microservice) {
        this.microservice = microservice;
    }

    public MicroserviceMetaManager getMicroserviceMetaManager() {
        return this.microserviceMetaManager;
    }

    public SchemaMeta getOrCreateSchemaMeta(Class<?> impl) {
        return this.getOrCreateSchemaMeta("app", "test", impl.getName(), impl);
    }

    public SchemaMeta getOrCreateSchemaMeta(String appId, String microserviceName, String schemaId, Class<?> impl) {
        String longName = appId + ":" + microserviceName;
        MicroserviceMeta microserviceMeta = this.microserviceMetaManager.getOrCreateMicroserviceMeta(longName);
        SchemaMeta schemaMeta = microserviceMeta.findSchemaMeta(schemaId);
        if (schemaMeta != null) {
            return schemaMeta;
        }
        Swagger swagger = UnitTestSwaggerUtils.generateSwagger(impl).getSwagger();
        return this.schemaLoader.registerSchema(microserviceMeta, schemaId, swagger);
    }

    static {
        UnitTestMeta.init();
    }
}

