/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.core.transport;

import io.servicecomb.core.Endpoint;
import io.servicecomb.core.Transport;
import io.servicecomb.core.endpoint.AbstractEndpointsCache;
import io.servicecomb.serviceregistry.RegistryUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TransportManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransportManager.class);
    @Inject
    private List<Transport> transportList;
    private Map<String, Transport> transportMap = new HashMap<String, Transport>();

    public void init() throws Exception {
        AbstractEndpointsCache.setTransportManager(this);
        for (Transport transport : this.transportList) {
            Endpoint endpoint;
            this.transportMap.put(transport.getName(), transport);
            if (!transport.init() || (endpoint = transport.getPublishEndpoint()) == null || endpoint.getEndpoint() == null) continue;
            LOGGER.info("endpoint to publish: {}", (Object)endpoint.getEndpoint());
            RegistryUtils.getMicroserviceInstance().getEndpoints().add(endpoint.getEndpoint());
        }
    }

    public Transport findTransport(String transportName) {
        return this.transportMap.get(transportName);
    }
}

