/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.core.provider.producer;

import io.servicecomb.core.AsyncResponse;
import io.servicecomb.core.Invocation;
import io.servicecomb.core.Response;
import io.servicecomb.core.context.ContextUtils;
import io.servicecomb.core.context.InvocationContext;
import io.servicecomb.core.exception.InvocationException;
import io.servicecomb.swagger.invocation.SwaggerInvocation;
import io.servicecomb.swagger.invocation.arguments.producer.ProducerArgumentsMapper;
import io.servicecomb.swagger.invocation.response.producer.ProducerResponseMapper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProducerOperation.class);
    private Object instance;
    private Method method;
    private ProducerArgumentsMapper argsMapper;
    private ProducerResponseMapper responseMapper;

    public ProducerOperation(Object instance, Method method, ProducerArgumentsMapper argsMapper, ProducerResponseMapper responseMapper) {
        this.instance = instance;
        this.method = method;
        this.argsMapper = argsMapper;
        this.responseMapper = responseMapper;
    }

    public void invoke(Invocation invocation, AsyncResponse asyncResp) {
        InvocationContext context = new InvocationContext(invocation.getContext());
        ContextUtils.setInvocationContext(context);
        Response response = null;
        try {
            Object[] args = this.argsMapper.toProducerArgs((SwaggerInvocation)invocation);
            Object result = this.method.invoke(this.instance, args);
            response = this.responseMapper.mapResponse(context.getStatus(), result);
        }
        catch (Throwable e) {
            response = this.processException(e);
        }
        ContextUtils.removeInvocationContext();
        asyncResp.handle(response);
    }

    protected Response processException(Throwable e) {
        if (InvocationTargetException.class.isInstance(e)) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        if (InvocationException.class.isInstance(e)) {
            return Response.failResp((InvocationException)((InvocationException)e));
        }
        Response response = Response.producerFailResp((Throwable)e);
        String msg = String.format("Producer invoke failed, %s:%s", this.method.getDeclaringClass().getName(), this.method.getName());
        LOGGER.error(msg, e);
        return response;
    }
}

