/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.core.provider.consumer;

import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import io.servicecomb.core.ConsumerProvider;
import io.servicecomb.core.provider.consumer.ReferenceConfig;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class ConsumerProviderManager {
    @Inject
    private List<ConsumerProvider> consumerProviderList;
    private volatile Map<String, ReferenceConfig> referenceConfigMap = new ConcurrentHashMap<String, ReferenceConfig>();

    public void init() throws Exception {
        for (ConsumerProvider provider : this.consumerProviderList) {
            provider.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferenceConfig getReferenceConfig(String microserviceName) {
        ReferenceConfig config = this.referenceConfigMap.get(microserviceName);
        if (config == null) {
            ConsumerProviderManager consumerProviderManager = this;
            synchronized (consumerProviderManager) {
                config = this.referenceConfigMap.get(microserviceName);
                if (config == null) {
                    String key = "cse.references." + microserviceName;
                    DynamicStringProperty versionRule = DynamicPropertyFactory.getInstance().getStringProperty(key + ".version-rule", "latest");
                    DynamicStringProperty transport = DynamicPropertyFactory.getInstance().getStringProperty(key + ".transport", "");
                    config = new ReferenceConfig(microserviceName, versionRule.getValue(), transport.getValue());
                    this.referenceConfigMap.put(microserviceName, config);
                }
            }
        }
        return config;
    }

    public ReferenceConfig setTransport(String microserviceName, String transport) {
        ReferenceConfig config = this.getReferenceConfig(microserviceName);
        config.setTransport(transport);
        return config;
    }
}

