/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.core.invocation;

import com.netflix.config.DynamicPropertyFactory;
import io.servicecomb.core.Endpoint;
import io.servicecomb.core.Invocation;
import io.servicecomb.core.definition.MicroserviceMeta;
import io.servicecomb.core.definition.OperationMeta;
import io.servicecomb.core.definition.SchemaMeta;
import io.servicecomb.core.provider.consumer.ReferenceConfig;

public final class InvocationFactory {
    private static String microserviceName = InvocationFactory.getMicroserviceName();

    private InvocationFactory() {
    }

    private static String getMicroserviceName() {
        return DynamicPropertyFactory.getInstance().getStringProperty("service_description.name", null).get();
    }

    public static void setMicroserviceName(String microserviceName) {
        InvocationFactory.microserviceName = microserviceName;
    }

    public static Invocation forConsumer(ReferenceConfig referenceConfig, OperationMeta operationMeta, Object[] swaggerArguments) {
        Invocation invocation = new Invocation(referenceConfig, operationMeta, swaggerArguments);
        invocation.addContext("x-cse-src-microservice", microserviceName);
        return invocation;
    }

    public static Invocation forConsumer(ReferenceConfig referenceConfig, SchemaMeta schemaMeta, String operationName, Object[] swaggerArguments) {
        OperationMeta operationMeta = (OperationMeta)schemaMeta.ensureFindOperation(operationName);
        Invocation invocation = new Invocation(referenceConfig, operationMeta, swaggerArguments);
        invocation.addContext("x-cse-src-microservice", microserviceName);
        return invocation;
    }

    public static Invocation forConsumer(ReferenceConfig referenceConfig, String operationQualifiedName, Object[] swaggerArguments) {
        MicroserviceMeta microserviceMeta = referenceConfig.getMicroserviceMeta();
        OperationMeta operationMeta = (OperationMeta)microserviceMeta.ensureFindOperation(operationQualifiedName);
        Invocation invocation = new Invocation(referenceConfig, operationMeta, swaggerArguments);
        invocation.addContext("x-cse-src-microservice", microserviceName);
        return invocation;
    }

    public static Invocation forProvider(Endpoint endpoint, OperationMeta operationMeta, Object[] swaggerArguments) {
        return new Invocation(endpoint, operationMeta, swaggerArguments);
    }
}

