/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.core.definition.schema;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.servicecomb.core.definition.MicroserviceMeta;
import io.servicecomb.core.definition.OperationMeta;
import io.servicecomb.core.definition.SchemaMeta;
import io.servicecomb.core.definition.schema.AbstractSchemaFactory;
import io.servicecomb.core.definition.schema.ProducerSchemaContext;
import io.servicecomb.core.provider.producer.ProducerOperation;
import io.servicecomb.foundation.common.utils.ReflectUtils;
import io.servicecomb.swagger.generator.core.OperationGenerator;
import io.servicecomb.swagger.generator.core.SwaggerGenerator;
import io.servicecomb.swagger.generator.core.utils.ClassUtils;
import io.servicecomb.swagger.invocation.arguments.producer.ProducerArgumentsMapper;
import io.servicecomb.swagger.invocation.arguments.producer.ProducerArgumentsMapperFactory;
import io.servicecomb.swagger.invocation.response.producer.ProducerResponseMapper;
import io.servicecomb.swagger.invocation.response.producer.ProducerResponseMapperFactory;
import io.swagger.models.Swagger;
import io.swagger.util.Yaml;
import java.lang.reflect.Method;
import java.util.List;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProducerSchemaFactory
extends AbstractSchemaFactory<ProducerSchemaContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProducerSchemaFactory.class);
    private ObjectWriter writer = Yaml.pretty();
    @Inject
    private ProducerResponseMapperFactory responseMapperFactory;
    @Inject
    protected ProducerArgumentsMapperFactory producerArgsMapperFactory;

    private String getSwaggerContent(Swagger swagger) {
        try {
            return this.writer.writeValueAsString((Object)swagger);
        }
        catch (JsonProcessingException e) {
            throw new Error(e);
        }
    }

    public SchemaMeta getOrCreateProducerSchema(String microserviceName, String schemaId, Class<?> producerClass, Object producerInstance) {
        MicroserviceMeta microserviceMeta = this.microserviceMetaManager.getOrCreateMicroserviceMeta(microserviceName);
        ProducerSchemaContext context = new ProducerSchemaContext();
        context.setMicroserviceMeta(microserviceMeta);
        context.setSchemaId(schemaId);
        context.setProviderClass(producerClass);
        context.setProducerInstance(producerInstance);
        return this.getOrCreateSchema(context);
    }

    @Override
    protected void connectToProvider(ProducerSchemaContext context) {
        if (context.getGenerator() == null) {
            this.generateSwagger(context);
        }
        Class swaggerIntf = ClassUtils.getJavaInterface((Swagger)context.getSchemaMeta().getSwagger());
        for (OperationMeta operationMeta : context.getSchemaMeta().getOperations()) {
            OperationGenerator operationGenerator = (OperationGenerator)context.getGenerator().getOperationGeneratorMap().get(operationMeta.getOperationId());
            Method swaggerMethod = ReflectUtils.findMethod((Class)swaggerIntf, (String)operationMeta.getOperationId());
            List swaggerParameters = operationMeta.getSwaggerOperation().getParameters();
            Method producerMethod = operationGenerator.getProviderMethod();
            List producerParameters = operationGenerator.getProviderParameters();
            ProducerArgumentsMapper argsMapper = (ProducerArgumentsMapper)this.producerArgsMapperFactory.createArgumentsMapper(context.getSchemaMeta().getSwagger(), swaggerMethod, swaggerParameters, producerMethod, producerParameters);
            this.createOperation(context, operationMeta, argsMapper);
        }
    }

    @Override
    protected SwaggerGenerator generateSwagger(ProducerSchemaContext context) {
        SwaggerGenerator generator = super.generateSwagger(context);
        context.setGenerator(generator);
        return generator;
    }

    @Override
    protected SchemaMeta createSchema(ProducerSchemaContext context) {
        Swagger swagger = this.loadSwagger(context);
        SwaggerGenerator generator = this.generateSwagger(context);
        if (swagger == null) {
            swagger = generator.getSwagger();
            String swaggerContent = this.getSwaggerContent(swagger);
            LOGGER.info("generate swagger for {}/{}/{}, swagger: {}", new Object[]{context.getMicroserviceMeta().getAppId(), context.getMicroserviceName(), context.getSchemaId(), swaggerContent});
        }
        return this.schemaLoader.registerSchema(context.getMicroserviceMeta(), context.getSchemaId(), swagger);
    }

    protected void createOperation(ProducerSchemaContext context, OperationMeta operationMeta, ProducerArgumentsMapper argsMapper) {
        Object producerInstance = context.getProducerInstance();
        Method method = ReflectUtils.findMethod(producerInstance.getClass(), (String)operationMeta.getMethod().getName());
        ProducerResponseMapper responseMapper = this.responseMapperFactory.createResponseMapper(method.getReturnType());
        ProducerOperation producerOperation = new ProducerOperation(producerInstance, method, argsMapper, responseMapper);
        operationMeta.putExtData("producer-operation", producerOperation);
    }
}

