/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.core.definition.schema;

import io.servicecomb.core.definition.MicroserviceMeta;
import io.servicecomb.core.definition.OperationMeta;
import io.servicecomb.core.definition.SchemaMeta;
import io.servicecomb.core.definition.SchemaUtils;
import io.servicecomb.core.definition.loader.SchemaListenerManager;
import io.servicecomb.core.definition.schema.AbstractSchemaFactory;
import io.servicecomb.core.definition.schema.ConsumerSchemaContext;
import io.servicecomb.core.provider.consumer.ConsumerOperationMeta;
import io.servicecomb.foundation.common.config.PaaSResourceUtils;
import io.servicecomb.foundation.common.utils.ReflectUtils;
import io.servicecomb.serviceregistry.api.registry.Microservice;
import io.servicecomb.serviceregistry.client.RegistryClientFactory;
import io.servicecomb.serviceregistry.client.ServiceRegistryClient;
import io.servicecomb.swagger.generator.core.OperationGenerator;
import io.servicecomb.swagger.generator.core.SwaggerGenerator;
import io.servicecomb.swagger.generator.core.utils.ClassUtils;
import io.servicecomb.swagger.invocation.arguments.consumer.ConsumerArgumentSame;
import io.servicecomb.swagger.invocation.arguments.consumer.ConsumerArgumentsMapper;
import io.servicecomb.swagger.invocation.arguments.consumer.ConsumerArgumentsMapperFactory;
import io.servicecomb.swagger.invocation.response.consumer.ConsumerResponseMapper;
import io.servicecomb.swagger.invocation.response.consumer.ConsumerResponseMapperFactory;
import io.swagger.models.Swagger;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class ConsumerSchemaFactory
extends AbstractSchemaFactory<ConsumerSchemaContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerSchemaFactory.class);
    @Inject
    protected SchemaListenerManager schemaListenerManager;
    @Inject
    protected ConsumerArgumentsMapperFactory consumerArgsMapperFactory;
    @Inject
    protected ConsumerResponseMapperFactory responseMapperFactory;
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MicroserviceMeta getOrCreateConsumer(String microserviceName, String microserviceVersionRule) {
        MicroserviceMeta microserviceMeta = (MicroserviceMeta)this.microserviceMetaManager.findValue(microserviceName);
        if (microserviceMeta != null) {
            return microserviceMeta;
        }
        Object object = this.lock;
        synchronized (object) {
            microserviceMeta = (MicroserviceMeta)this.microserviceMetaManager.findValue(microserviceName);
            if (microserviceMeta != null) {
                return microserviceMeta;
            }
            microserviceMeta = new MicroserviceMeta(microserviceName);
            Set<String> schemaIds = this.findLocalSchemas(microserviceMeta);
            Microservice microservice = this.findMicroservice(microserviceMeta, microserviceVersionRule);
            if (microservice != null) {
                schemaIds.addAll(microservice.getSchemas());
            }
            this.getOrCreateConsumerSchema(microserviceMeta, schemaIds, microservice);
            this.microserviceMetaManager.register(microserviceName, microserviceMeta);
            this.schemaListenerManager.notifySchemaListener(microserviceMeta);
            return microserviceMeta;
        }
    }

    protected Set<String> findLocalSchemas(MicroserviceMeta microserviceMeta) {
        String resPath = this.generateSchemaPath(microserviceMeta.getName(), "*");
        Resource[] resArr = PaaSResourceUtils.getResources((String)("classpath*:" + resPath));
        HashSet<String> schemaIds = new HashSet<String>();
        for (Resource res : resArr) {
            String schemaId = FilenameUtils.getBaseName((String)res.getFilename());
            schemaIds.add(schemaId);
        }
        LOGGER.info("Found schema ids local, {}:{}:{}", new Object[]{microserviceMeta.getAppId(), microserviceMeta.getName(), schemaIds});
        return schemaIds;
    }

    protected Microservice findMicroservice(MicroserviceMeta microserviceMeta, String microserviceVersionRule) {
        String appId = microserviceMeta.getAppId();
        String microserviceName = microserviceMeta.getName();
        ServiceRegistryClient client = RegistryClientFactory.getRegistryClient();
        String microserviceId = client.getMicroserviceId(appId, microserviceMeta.getShortName(), microserviceVersionRule);
        if (StringUtils.isEmpty((Object)microserviceId)) {
            LOGGER.error("can not get microservice id, {}:{}:{}", new Object[]{appId, microserviceName, microserviceVersionRule});
            return null;
        }
        Microservice microservice = client.getMicroservice(microserviceId);
        if (microservice == null) {
            LOGGER.error("can not get microservice, {}:{}:{}", new Object[]{appId, microserviceName, microserviceVersionRule});
            return null;
        }
        LOGGER.info("Found schema ids from service center, {}:{}:{}:{}", new Object[]{appId, microserviceName, microserviceVersionRule, microservice.getSchemas()});
        return microservice;
    }

    protected void getOrCreateConsumerSchema(MicroserviceMeta microserviceMeta, Set<String> schemaIds, Microservice microservice) {
        for (String schemaId : schemaIds) {
            ConsumerSchemaContext context = new ConsumerSchemaContext();
            context.setMicroserviceMeta(microserviceMeta);
            context.setMicroservice(microservice);
            context.setSchemaId(schemaId);
            context.setProviderClass(null);
            context.setConsumerOperationMap(null);
            this.getOrCreateSchema(context);
        }
    }

    @Override
    protected void connectToProvider(ConsumerSchemaContext context) {
    }

    public void connectToConsumer(SchemaMeta schemaMeta, Class<?> consumerIntf, Map<String, ConsumerOperationMeta> consumerOperationMap) {
        MicroserviceMeta microserviceMeta = schemaMeta.getMicroserviceMeta();
        ConsumerSchemaContext context = new ConsumerSchemaContext();
        context.setMicroserviceMeta(microserviceMeta);
        context.setSchemaId(schemaMeta.getSchemaId());
        context.setSchemaMeta(schemaMeta);
        context.setProviderClass(consumerIntf);
        context.setConsumerOperationMap(consumerOperationMap);
        if (consumerIntf == null) {
            consumerIntf = schemaMeta.getSwaggerIntf();
            context.setProviderClass(consumerIntf);
        }
        if (consumerIntf.equals(schemaMeta.getSwaggerIntf())) {
            this.mapSameIntfParameters(context);
            return;
        }
        this.mapDiffIntfParameters(context);
    }

    protected void mapSameIntfParameters(ConsumerSchemaContext context) {
        for (OperationMeta operationMeta : context.getSchemaMeta().getOperations()) {
            ArrayList<ConsumerArgumentSame> consumerArgMapperList = new ArrayList<ConsumerArgumentSame>();
            int swaggerParameterCount = operationMeta.getSwaggerOperation().getParameters().size();
            for (int idx = 0; idx < swaggerParameterCount; ++idx) {
                ConsumerArgumentSame argMapper = new ConsumerArgumentSame(idx, idx);
                consumerArgMapperList.add(argMapper);
            }
            ConsumerArgumentsMapper argsMapper = new ConsumerArgumentsMapper(consumerArgMapperList, swaggerParameterCount);
            this.createOperation(context, operationMeta, argsMapper);
        }
    }

    protected void mapDiffIntfParameters(ConsumerSchemaContext context) {
        Class swaggerIntf = ClassUtils.getJavaInterface((Swagger)context.getSchemaMeta().getSwagger());
        SwaggerGenerator generator = this.generateSwagger(context);
        for (OperationMeta operationMeta : context.getSchemaMeta().getOperations()) {
            OperationGenerator operationGenerator = (OperationGenerator)generator.getOperationGeneratorMap().get(operationMeta.getOperationId());
            if (operationGenerator == null) continue;
            Method swaggerMethod = ReflectUtils.findMethod((Class)swaggerIntf, (String)operationMeta.getOperationId());
            List swaggerParameters = operationMeta.getSwaggerOperation().getParameters();
            Method consumerMethod = operationGenerator.getProviderMethod();
            List consumerParameters = operationGenerator.getProviderParameters();
            ConsumerArgumentsMapper argsMapper = (ConsumerArgumentsMapper)this.consumerArgsMapperFactory.createArgumentsMapper(context.getSchemaMeta().getSwagger(), swaggerMethod, swaggerParameters, consumerMethod, consumerParameters);
            this.createOperation(context, operationMeta, argsMapper);
        }
    }

    @Override
    protected SchemaMeta createSchema(ConsumerSchemaContext context) {
        Swagger swagger = this.loadSwagger(context);
        return this.schemaLoader.registerSchema(context.getMicroserviceMeta(), context.getSchemaId(), swagger);
    }

    @Override
    protected Swagger loadSwagger(ConsumerSchemaContext context) {
        Swagger swagger = super.loadSwagger(context);
        if (swagger != null) {
            return swagger;
        }
        if (context.getMicroservice() == null) {
            throw new Error(String.format("no schema in local, and can not get microservice from service center, %s:%s", context.getMicroserviceName(), context.getSchemaId()));
        }
        ServiceRegistryClient client = RegistryClientFactory.getRegistryClient();
        String schemaContent = client.getSchema(context.getMicroservice().getServiceId(), context.getSchemaId());
        LOGGER.info("load schema from service center, microservice={}:{}:{}, schemaId={}, result={}", new Object[]{context.getMicroservice().getAppId(), context.getMicroservice().getServiceName(), context.getMicroservice().getVersion(), context.getSchemaId(), !StringUtils.isEmpty((Object)schemaContent)});
        if (schemaContent != null) {
            return SchemaUtils.parseSwagger(schemaContent);
        }
        throw new Error(String.format("no schema in local, and can not get schema from service center, %s:%s", context.getMicroserviceName(), context.getSchemaId()));
    }

    protected void createOperation(ConsumerSchemaContext context, OperationMeta operationMeta, ConsumerArgumentsMapper argsMapper) {
        if (context.getConsumerOperationMap() == null) {
            return;
        }
        Method method = ReflectUtils.findMethod(context.getProviderClass(), (String)operationMeta.getMethod().getName());
        ConsumerResponseMapper responseMapper = this.responseMapperFactory.createResponseMapper(method.getReturnType());
        ConsumerOperationMeta consumerOperationMeta = new ConsumerOperationMeta(operationMeta, argsMapper, responseMapper);
        context.getConsumerOperationMap().put(operationMeta.getMethod().getName(), consumerOperationMeta);
    }
}

